/**************** (c) 2000  STMicroelectronics **********************

PROJECT : USB - ST7 FULL SPEED

VERSION :  v 0.96

CREATION DATE :  01/12/2000

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#include "mcu_conf.h"

#include "MConfig.h"
#include "MAL.h"
#include "MAL_Func.h"

#pragma CODE_SEG INT_CODE

/* ************************ INTERRUPT FUNCTIONS *******************************/


/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Trap
DESCRIPTION  : TRAP interrupt routine.
-----------------------------------------------------------------------------*/ 
#pragma TRAP_PROC //SAVE_REGS
void dummy(void)
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_I2c
DESCRIPTION  : Comes from the I2C cell.
-----------------------------------------------------------------------------*/ 
#pragma TRAP_PROC //SAVE_REGS
void INT_I2C(void)
{ 
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_DTC
DESCRIPTION  : Comes from the FCI cell
-----------------------------------------------------------------------------*/ 
#pragma TRAP_PROC SAVE_REGS
void INT_DTC(void)
{
	// Dispatch the interrupt processing to different MAL_XXX
	asm {
		LD		X, MAL_Mediano
		SLL		X
		LD		A, (MAL_DTC_Int:1,X)
		LD		_LEX:1, A
		LD		A, (MAL_DTC_Int,X)
		LD		_LEX, A
		CALL	[_LEX.w]
	}
//	(*MAL_DTC_Int[MAL_Mediano])();
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_TIM
DESCRIPTION  : Comes from the TIM cell.
-----------------------------------------------------------------------------*/ 
#pragma TRAP_PROC // SAVE_REGS
void INT_TIM(void)
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_EI1
DESCRIPTION  : External Interrupt
-----------------------------------------------------------------------------*/ 
#pragma TRAP_PROC SAVE_REGS
void INT_EI1(void)
{                  
//------------------ I/O ports initialization ----------
Init_port();	

}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_EI0
DESCRIPTION  : External Interrupt
-----------------------------------------------------------------------------*/ 
#pragma TRAP_PROC SAVE_REGS
void INT_EI0(void)
{
Init_port();
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_DEVCONINT
DESCRIPTION  : Comes from the I2C cell.
-----------------------------------------------------------------------------*/ 
#pragma TRAP_PROC //SAVE_REGS
void INT_DEVCONINT(void)
{
/*	// Power Mngt with battery
	PFDDR =0x00;
	CTLR &=0xFD;
	WDGCR = 0xC0; 
	while(1)
	{
		asm NOP
	}
*/
}

//#pragma DATA_SEG STACK_SEG
//unsigned char Stack[0xB0];
/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Trap
DESCRIPTION  : TRAP interrupt routine.
-----------------------------------------------------------------------------*/ 
#pragma TRAP_PROC //SAVE_REGS
void INT_Trap(void)
{
	asm {
		ld		Y, S
		sla		X					// Index
		add		A, (MAL_Func:0x01,X)
		ld		(0x105,Y), A
		clr		A
		adc		A, (MAL_Func,X)
		ld		(0x104,Y), A
	}
}

/**************** (c) 2000  STMicroelectronics **********************/