/**************** (c) 2000  STMicroelectronics **********************

PROJECT : ST7265 5in1 Demo with DFU feature

VERSION :  V1.0

CREATION DATE :  15/07/2002

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#include "DFU.h"
#include "mcu_conf.h"

#pragma CODE_SEG MAIN_CODE

void Init_RAM()
{
	// To initialize the DEFAULT_RAM
	asm {
		ld		A, #$02
		ld		_LEX, A
		clr		A
		ld		_LEX:1, A
loop:
		clr		X
loop1:
		ld		([_LEX.w],X), A
		inc		X
		jrne	loop1

		inc		_LEX
		ld		X, _LEX
		cp		X, #$01A
		jrne	loop
	}

	// Clear stack area. (Some stack area is used for variables)
	asm {
		ld		X, #0xFD
loop2:
		ld		(0x100,X), A
		dec		x
		jrne	loop2
		ld		0x100, A
	}

	asm {
		ld		X, #$052
loop0:
		clr		(X)
		inc		X
		jrne	loop0
	}
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : main
INPUT/OUTPUT : None
DESCRIPTION  : The reset vector points on main().
-----------------------------------------------------------------------------*/                 
void main(void)
{
	extern void Init_USB(void);		// import from USB_Lib.c
	extern void USB_Polling(void);	// import from USB_Int.c

	extern void DFU_Init(void);
	extern unsigned int Set_Label(void);
	extern unsigned int Reset_point;

	Init_RAM();				// To clear all the variables

	Init_USB();

Reset_point = Set_Label();
	if (DFU_State == STATE_appDETACH
			// This is not DFU compliance.
			// Because MS-Windows sends many reset, we have to do this
			|| DFU_State == STATE_dfuIDLE) {
		DFU_State = STATE_dfuIDLE;
		goto DFU_point;
	}

	if (DFU_App_Valid()) {	// Check the application ROM sector is valid
		// Prepare application descriptor set
		asm	RIM;			// Enable Interrupt
		Vec_main();			// This function will never return!!
	}

	DFU_State = STATE_dfuERROR;
	DFU_Status.bStatus = DFU_STATUS_ERRFIRMWARE;	

DFU_point:
	DFU_Init();
	asm	RIM;				// Enable Interrupt

	while(1)				// DFU main loop
	{   
#ifdef	USB_POLLING_MODEL
		USB_Polling();
#endif
	}
}


/**************** (c) 2000  STMicroelectronics **********************/
