/**************** (c) 2000  STMicroelectronics **********************

PROJECT : USB - ST7 FULL SPEED

VERSION :  v 0.96

CREATION DATE :  01/12/2000

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : ST72F65 Hardware Register Mapping.

              This file contains the description of the hardware register of
              the ST72F65 IC. Variable forced to a fixed address.

              WARNING : this file need a specific LINKER configuration file !

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/
#include "stdtypes.h"
#include "map_7265.h"

/********************************************/
/*	                 HW Reg             */
/********************************************/
/* A PORT REGISTERS */
#pragma DATA_SEG SHORT PORTA
volatile char PADR;                             /* PORT A : Data	 */
volatile char PADDR;                            /* Data Direction */
volatile char PAOR;                             /* PORT A : OR	 */

/* B PORT REGISTERS */
#pragma DATA_SEG SHORT PORTB
volatile char PBDR;                              /* PORT B : Data */
volatile char PBDDR;                             /* Data Direction*/
                        
/* C PORT REGISTERS */
#pragma DATA_SEG SHORT PORTC
volatile char PCDR;                              /* PORT C : Data */
volatile char PCDDR;                             /* Data Direction*/
volatile char PCOR;                              /* PORT C : OR   */

/* D PORT REGISTERS */
#pragma DATA_SEG SHORT PORTD
volatile char PDDR;                              /* PORT D : Data  */
volatile char PDDDR;                             /* Data Direction */
volatile char PDOR;                             /* PORT D : OR	  */

/* E PORT REGISTERS */
#pragma DATA_SEG SHORT PORTE
volatile char PEDR;                              /* PORT E : Data  */
volatile char PEDDR;                             /* Data Direction */
volatile char PEOR;                             /* PORT E : OR	  */

/* F PORT REGISTERS */
#pragma DATA_SEG SHORT PORTF
volatile char PFDR;                              /* PORT F : Data	*/
volatile char PFDDR;                             /* Data Direction	*/
volatile char PFOR;                             /* PORT F : OR		*/

/* A/D CONVERTER */
#pragma DATA_SEG SHORT ADC
volatile char ADCDR;                             /* Data Register	*/
volatile char ADCCSR;                            /* Control/Status Register	*/

/* WATCHDOG */
#pragma DATA_SEG SHORT WDG
volatile char WDGCR;                             /* Watchdog Control Register */           

/* DSM */
#pragma DATA_SEG SHORT DSM
volatile char PCR;								 /* Power Control Register	*/

/* SPI */
#pragma DATA_SEG SHORT SPI
volatile char SPIDR;
volatile char SPICR;
volatile char SPICSR;

/* DTC */
#pragma DATA_SEG SHORT DTC
volatile char DTCCTRL;                           /* DTC Control Register	*/
volatile char DTCSTATUS;                         /* DTC Status Register	*/
volatile char DTCCRC_RESERVED;                   /* Reserved DTC CRC Register	*/
volatile char DTCPC;                             /* DTC Program Counter Register	*/

/* TIM */
#pragma DATA_SEG SHORT TIM
volatile char TCR1;                              /* timer control register 1 */
volatile char TCR2;                              /* timer control register 2 */
volatile char TSR;                               /* timer status  register   */
volatile char CRH;                               /* timer counter H register (15:8) */
volatile char CRL;                               /* timer counter L register (7:0) */
volatile char CHRA;                              /* timer alternate counter H register (15:8) */
volatile char CLRA;                              /* timer alternate counter L register (7:0) */
volatile char OCHR1;                             /* timer output compare H register 1 */
volatile char OCLR1;                             /* timer output compare L register 1 */
volatile char OCHR2;                             /* timer output compare H register 2 */
volatile char OCLR2;                             /* timer output compare L register 2 */

#pragma DATA_SEG SHORT FLASH
volatile char FCSR;		// Flash control status register

/* SW ITC */
#pragma DATA_SEG SHORT ITC
volatile char ITSPR0;			// Interrupt Software Priority Register 0
volatile char ITSPR1;			// Interrupt Software Priority Register 1
volatile char ITSPR2;			// Interrupt Software Priority Register 2
volatile char ITSPR3;			// Interrupt Software Priority Register 3

/* USB */
#pragma DATA_SEG SHORT USB
volatile char USBISTR;                              /* Interrupt StaTus Register*/
volatile char USBIMR;                               /* Interrupt Mask Register */
volatile char USBCTLR;                              /* Control Register */
volatile char DADDR;                             /* Device ADDress Register */
volatile char USBSR;                             /* USB Status Register */
volatile char EP0R;                              /* Endpoint 0 Register */
volatile char CNT0RXR;                           /* CouNT endp. 0 Reception Register */
volatile char CNT0TXR;                           /* CouNT endp. 0 Reception Register */
volatile char EP1RXR;                            /* Endpoint 1 Reception Register */
volatile char CNT1RXR;                           /* CouNT endp. 1 Reception Register */
volatile char EP1TXR;                            /* Endpoint 1 Transmission Register */
volatile char CNT1TXR;                           /* CouNT endp. 1 Transmission Register */
volatile char EP2RXR;                            /* Endpoint 2 Reception Register */
volatile char CNT2RXR;                           /* CouNT endp. 2 Reception Register */
volatile char EP2TXR;                            /* Endpoint 2 Transmission Register */
volatile char CNT2TXR;                           /* CouNT endp. 2 Reception Register */

/* I2C INTERFACE */
#pragma DATA_SEG SHORT I2C
volatile char I2CCR;                             /* i2c control register */
volatile char I2CSR1;                            /* i2c status register 1 */
volatile char I2CSR2;                            /* i2c status register 2 */
volatile char I2CCCR;                            /* i2c clock control register */
volatile char I2COAR1;                           /* i2c own address register 1 */
volatile char I2COAR2;                           /* i2c own address register 2 */
volatile char I2CDR;                             /* i2c data register */

/* USB */
#pragma DATA_SEG SHORT USBBUFSR                 
volatile char BUFSR;							 /* Buffer Manager status register */

/* MISCELLANEOUS */
#pragma DATA_SEG SHORT MISCR
volatile char MISCR1;                             /* Miscellaneous Register 1	*/
volatile char MISCR2;                             /* Miscellaneous Register 2	*/
volatile char MISCR_RESERVED;                     /* Reserved Miscellaneous Register	*/
volatile char MISCR3;                             /* Miscellaneous Register 3	*/

/* PWM */
#pragma DATA_SEG SHORT PWM
volatile char PWM0;                                    /* pbm: PWM 0 register */ 
volatile char BRM10;                                   /* pbm: BRM 0 register ( for 4bit brm0 and brm1 ) */
volatile char PWM1;                                    /* pbm: PWM 1 register */

#pragma DATA_SEG EP0_OUT		// Map user variables in USB DATA BUFFERS.
volatile char EP0_OUT[16];

#pragma DATA_SEG EP0_IN		// Map user variables in USB DATA BUFFERS.
volatile char EP0_IN[16];  

#pragma DATA_SEG EP1_OUT
volatile char EP1_OUT[16];

#pragma DATA_SEG EP1_IN
volatile char EP1_IN[16];

#pragma DATA_SEG EP2_OUT
volatile char EP2_OUT[64];

#pragma DATA_SEG EP2_IN
volatile char EP2_IN[64];

/********************************************/
/*	               Buffer 0             */
/********************************************/
#pragma DATA_SEG BULK_BUFFER0	// Map user variables in BUFFER.
volatile char Buffer_0[512];	// RAM BUFFER

/********************************************/
/*	               Buffer 1             */
/********************************************/
#pragma DATA_SEG BULK_BUFFER1	// Map user variables in BUFFER.
volatile char Buffer_1[512];	// RAM BUFFER

/**************** (c) 2000  STMicroelectronics **********************/


