/**************** (c) 2000  STMicroelectronics **********************

PROJECT : USB - ST7 FULL SPEED

VERSION :  v 0.96

CREATION DATE :  01/12/2000

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : ST72E65 Hardware Register Mapping.

              This file contains the description of the hardware register of
              the ST72E65 IC. Variable forced to a fixed address.

              WARNING : this file need a specific LINKER configuration file !
              --> The .prm file !


******************************************************************************/

#ifndef MAP_7265_H
#define MAP_7265_H

/********************************************/
/*	                 HW Reg             */
/********************************************/
/* A PORT REGISTERS */
#pragma DATA_SEG SHORT PORTA
extern volatile char PADR;                             /* PORT A : Data	 */
extern volatile char PADDR;                            /* Data Direction */
extern volatile char PAOR;                             /* PORT A : OR	 */

/* B PORT REGISTERS */
#pragma DATA_SEG SHORT PORTB
extern volatile char PBDR;                              /* PORT B : Data */
extern volatile char PBDDR;                             /* Data Direction*/
                        
/* C PORT REGISTERS */
#pragma DATA_SEG SHORT PORTC
extern volatile char PCDR;                              /* PORT C : Data */
extern volatile char PCDDR;                             /* Data Direction*/
extern volatile char PCOR;                              /* PORT C : OR   */

/* D PORT REGISTERS */
#pragma DATA_SEG SHORT PORTD
extern volatile char PDDR;                              /* PORT D : Data  */
extern volatile char PDDDR;                             /* Data Direction */
extern volatile char PDOR;                             /* PORT D : OR	  */

/* E PORT REGISTERS */
#pragma DATA_SEG SHORT PORTE
extern volatile char PEDR;                              /* PORT E : Data  */
extern volatile char PEDDR;                             /* Data Direction */
extern volatile char PEOR;                             /* PORT E : OR	  */

/* F PORT REGISTERS */
#pragma DATA_SEG SHORT PORTF
extern volatile char PFDR;                              /* PORT F : Data	*/
extern volatile char PFDDR;                             /* Data Direction	*/
extern volatile char PFOR;                             /* PORT F : OR		*/

/* A/D CONVERTER */
#pragma DATA_SEG SHORT ADC
extern volatile char ADCDR;                             /* Data Register	*/
extern volatile char ADCCSR;                            /* Control/Status Register	*/

/* WATCHDOG */
#pragma DATA_SEG SHORT WDG
extern volatile char WDGCR;                             /* Watchdog Control Register */

/* DSM */
#pragma DATA_SEG SHORT DSM
extern volatile char PCR;                              /* Power Control Register	*/
 
/* SPI */
#pragma DATA_SEG SHORT SPI
extern volatile char SPIDR;
extern volatile char SPICR;
extern volatile char SPICSR;

/* DTC */
#pragma DATA_SEG SHORT DTC
extern volatile char DTCCTRL;                           /* DTC Control Register	*/
extern volatile char DTCSTATUS;                         /* DTC Status Register	*/
extern volatile char DTCCRC_RESERVED;                   /* Reserved DTC CRC Register	*/
extern volatile char DTCPC;                             /* DTC Program Counter Register	*/

/* TIM */
#pragma DATA_SEG SHORT TIM
extern volatile char TCR1;                              /* timer control register 1 */
extern volatile char TCR2;                              /* timer control register 2 */
extern volatile char TSR;                               /* timer status  register   */
extern volatile char CRH;                               /* timer counter H register (15:8) */
extern volatile char CRL;                               /* timer counter L register (7:0) */
extern volatile char CHRA;                              /* timer alternate counter H register (15:8) */
extern volatile char CLRA;                              /* timer alternate counter L register (7:0) */
extern volatile char OCHR1;                             /* timer output compare H register 1 */
extern volatile char OCLR1;                             /* timer output compare L register 1 */
extern volatile char OCHR2;                             /* timer output compare H register 2 */
extern volatile char OCLR2;                             /* timer output compare L register 2 */

#pragma DATA_SEG SHORT FLASH
extern volatile char FCSR;		// Flash control status register

/* SW ITC */
#pragma DATA_SEG SHORT ITC
extern volatile char ITSPR0;		// Interrupt Software Priority Register 0
extern volatile char ITSPR1;		// Interrupt Software Priority Register 1
extern volatile char ITSPR2;		// Interrupt Software Priority Register 2
extern volatile char ITSPR3;		// Interrupt Software Priority Register 3

/* USB */ 
#pragma DATA_SEG SHORT USB
extern volatile char USBISTR;                              /* Interrupt StaTus Register*/
extern volatile char USBIMR;                               /* Interrupt Mask Register */
extern volatile char USBCTLR;                              /* Control Register */
extern volatile char DADDR;                             /* Device ADDress Register */
extern volatile char USBSR;                             /* USB Status Register */
extern volatile char EP0R;                              /* Endpoint 0 Register */
extern volatile char CNT0RXR;                           /* CouNT endp. 0 Reception Register */
extern volatile char CNT0TXR;                           /* CouNT endp. 0 Reception Register */
extern volatile char EP1RXR;                            /* Endpoint 1 Reception Register */
extern volatile char CNT1RXR;                           /* CouNT endp. 1 Reception Register */
extern volatile char EP1TXR;                            /* Endpoint 1 Transmission Register */
extern volatile char CNT1TXR;                           /* CouNT endp. 1 Transmission Register */
extern volatile char EP2RXR;                            /* Endpoint 2 Reception Register */
extern volatile char CNT2RXR;                           /* CouNT endp. 2 Reception Register */
extern volatile char EP2TXR;                            /* Endpoint 2 Transmission Register */
extern volatile char CNT2TXR;                           /* CouNT endp. 2 Reception Register */

/* I2C INTERFACE */
#pragma DATA_SEG SHORT I2C
extern volatile char I2CCR;                             /* i2c control register */
extern volatile char I2CSR1;                            /* i2c status register 1 */
extern volatile char I2CSR2;                            /* i2c status register 2 */
extern volatile char I2CCCR;                            /* i2c clock control register */
extern volatile char I2COAR1;                           /* i2c own address register 1 */
extern volatile char I2COAR2;                           /* i2c own address register 2 */
extern volatile char I2CDR;                             /* i2c data register */

/* USB */
#pragma DATA_SEG SHORT USBBUFSR                 
extern volatile char BUFSR;								 /* Buffer Manager status register */

/* MISCELLANEOUS */
#pragma DATA_SEG SHORT MISCR
extern volatile char MISCR1;                             /* Miscellaneous Register 1	*/
extern volatile char MISCR2;                             /* Miscellaneous Register 2	*/
extern volatile char MISCR_RESERVED;                     /* Reserved Miscellaneous Register	*/
extern volatile char MISCR3;                             /* Miscellaneous Register 3	*/

/* PWM */
#pragma DATA_SEG SHORT PWM
extern volatile char PWM0;                  
extern volatile char BRM10;                           
extern volatile char PWM1;

#pragma DATA_SEG EP0_OUT		// Map user variables in USB DATA BUFFERS.
extern volatile char EP0_OUT[16];

#pragma DATA_SEG EP0_IN		// Map user variables in USB DATA BUFFERS.
extern volatile char EP0_IN[16];

#pragma DATA_SEG EP1_OUT
extern volatile char EP1_OUT[16];

#pragma DATA_SEG EP1_IN
extern volatile char EP1_IN[16];

#pragma DATA_SEG EP2_OUT
extern volatile char EP2_OUT[64];

#pragma DATA_SEG EP2_IN
extern volatile char EP2_IN[64];


/********************************************/
/*	               Buffer 0             */
/********************************************/
#pragma DATA_SEG BULK_BUFFER0		// Map user variables in BUFFER.
extern volatile char Buffer_0[512];	// RAM BUFFER

/********************************************/
/*	               Buffer 1             */
/********************************************/
#pragma DATA_SEG BULK_BUFFER1		// Map user variables in BUFFER.
extern volatile char Buffer_1[512];	// RAM BUFFER

#endif 

/**************** (c) 2000  STMicroelectronics **********************/








