/**************** (c) 1999  STMicroelectronics **********************

PROJECT : USB - ST7

VERSION :  v 2.71

CREATION DATE :  06/04/1999

AUTHOR : MICROCONTROLLER DIVISION / ST San Jose

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-


MODIFICATIONS : 11 / 21 / 1999

******************************************************************************/

#ifndef DEFINE_H
#define DEFINE_H

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

#define max(a,b)            (((a) > (b)) ? (a) : (b))
#define min(a,b)            (((a) < (b)) ? (a) : (b))

#define MAKEWORD(msb, lsb)      ((WORD)(((WORD)((BYTE)(msb))) << 8) | ((BYTE)(lsb)))
#define MAKELONG(msw, lsw)		((DWORD)(((WORD)(lsw)) | ((DWORD)((WORD)(msw))) << 16))
#define LOWORD(l)				((WORD)(l))
#define HIWORD(l)				((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)				((BYTE)(w))
#define HIBYTE(w)				((BYTE)(((WORD)(w) >> 8) & 0xFF))

typedef	unsigned char	BOOL;
#define	TRUE	1
#define	FALSE	0


typedef	union _uDWORD {
	unsigned long dword;
	unsigned int  word[2];
	unsigned char byte[4];
} _UDWORD;

#endif