/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_conf.h
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	03/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	This header file is used to configure the library for difference MCU
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#ifndef MCU_CONFIG_H
#define MCU_CONFIG_H

// Select one line from the following 3 lines
//#define MCU_ST7HUB
//#define MCU_ST7SCR
#define MCU_ST7265
//#define MCU_ST72RF

#ifdef MCU_ST72RF
#define LOW_SPEED	// For low speed
#define MCU_ST7265
#endif

// Select interrupt model by comment out the line below
// By default, the polling model is provided
#define USB_POLLING_MODEL

//#define LARGE_EP0			// Exchange more than 255 bytes on EP0
//#define DECLARE_EP1		// Comment out this line if you do not use EP1
#define DECLARE_EP2			// Comment out this line if you do not use EP2
//#define DECLARE_EP3		// Comment out this line if you do not use EP3
//#define DECLARE_EP4		// Comment out this line if you do not use EP4
//#define DECLARE_EP5		// Comment out this line if you do not use EP5

#define HUB_VID		0x0483	// VID of the HUB
#define HUB_PID		0x1234	// PID of the HUB
// Comment out this line if you want to run HUB in bus-powered
//#define HUB_SELF_POWER
// Comment out this line if you do not want external power control of the downstream ports
//#define HUB_EXT_PWCTL
/********************************************************************************************/
/********************************************************************************************/
/***********		DO  NOT  MODIFY  NOR  REMOVE  FOLLOWING SECTION					*********/
/********************************************************************************************/
/********************************************************************************************/

#ifdef LOW_SPEED
	#define MAX_PACKET_SIZE		8		// Maximum payload on EP0
	#define MAX_EP1_PACKET_SIZE	8		// Maximum payload on EP1
	#define MAX_EP2_PACKET_SIZE	8		// Maximum payload on EP2
#else
#ifdef MCU_ST7265
	#define MAX_PACKET_SIZE		16		// Maximum payload on EP0
	#define MAX_EP1_PACKET_SIZE	16		// Maximum payload on EP1
	#define MAX_EP2_PACKET_SIZE	64		// Maximum payload on EP2
#endif
#ifdef MCU_ST7SCR
	#define MAX_PACKET_SIZE		8		// Maximum payload on EP0
	#define MAX_EP1_PACKET_SIZE	8		// Maximum payload on EP1
	#define MAX_EP2_PACKET_SIZE	64		// Maximum payload on EP2
	#define MAX_EP3_PACKET_SIZE	8		// Maximum payload on EP3
	#define MAX_EP4_PACKET_SIZE	8		// Maximum payload on EP4
	#define MAX_EP5_PACKET_SIZE	8		// Maximum payload on EP5
#endif
#endif

// Define the range of RAM
#ifdef LOW_SPEED

#ifdef MCU_ST72RF
#include "map_72RF.h"
#endif

#ifdef MCU_ST72RF
#define RAM_START	0xB0
#define RAM_END		0xAAF
#endif

#else		// Full Speed devices
#ifdef MCU_ST7265
#include "map_7265.h"
#endif

#ifdef MCU_ST7SCR
#include "map_7SCR.h"
#endif

#ifdef MCU_ST7HUB
#include "map_7hub.h"
#define MCU_ST7SCR
#endif

#ifdef MCU_ST7265
#define RAM_START	0x50
#define RAM_END		0x1A4F
#endif

#ifdef MCU_ST7HUB
#define RAM_START	0x50
#define RAM_END		0x34F
#endif

#ifdef MCU_ST7SCR
#define RAM_START	0x50
#define RAM_END		0x34F
#endif

#endif	// LOW_SPEED

#include "usb_eps.h"

/********************************************************************/
#pragma DATA_SEG SHORT _ZEROPAGE
extern char _R_Z;
extern short _LEX, _SEX;

#endif	// MCU_CONFIG_H

/**************** (c) 2000  STMicroelectronics **********************/
