;********************************************************
;* Project:	ST7265 5in1 Demo with DFU feature	*
;* Version:	V1.0					*
;* Creation:	17/07/2002				*
;* Description:	This module should be in ROM sector 0	*
;*		for the sake of DFU. All interrupt will	*
;*		dispatch to other sectors.		*
;********************************************************

;; THIS FILE IS USED TO LINK THE WHOLE APPLICATION

	XDEF	Vec_main
	XDEF	VEC_Trap
	XDEF	VEC_Plug	; Power Management USB Plug/Unplug
	XDEF	VEC_EI0		; External Interrupt Port A
	XDEF	VEC_DTC		; DTC Peripheral Interrupt
	XDEF	VEC_EI1		; External Interrupt Port D
	XDEF	VEC_I2C		; I 2 C Interrupt
	XDEF	VEC_Timer	; Timer interrupt

	XDEF	Vec_App_init

	XDEF	Vec_USB_Setup
	XDEF	Vec_CopydataIN
	XDEF	Vec_CopydataOUT
	XDEF	Vec_Set_Configuration
	XDEF	Vec_Set_Interface
	XDEF	Vec_Get_Interface

	XDEF	Vec_Status_In
	XDEF	Vec_Status_Out

	XDEF	Vec_Set_Feature_Int
	XDEF	Vec_Set_Feature_EP
	XDEF	Vec_Clear_Feature_Int
	XDEF	Vec_Clear_Feature_EP

	XDEF	Vec_USB_Reset
	XDEF	Vec_USB_Suspend
	XDEF	Vec_USB_ESuspend
	XDEF	Vec_USB_SOF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	XREF	App_main
	XREF	INT_Trap
	XREF	INT_DEVCONINT
	XREF	INT_EI0
	XREF	INT_DTC
	XREF	INT_EI1
	XREF	INT_I2C
	XREF	INT_TIM

	XREF	App_init

	XREF	App_USB_Setup
	XREF	App_CopydataIN
	XREF	App_CopydataOUT
	XREF	App_Set_Configuration
	XREF	App_Set_Interface
	XREF	App_Get_Interface

	XREF	App_Status_In
	XREF	App_Status_Out

	XREF	App_Set_Feature_Int
	XREF	App_Set_Feature_EP
	XREF	App_Clear_Feature_Int
	XREF	App_Clear_Feature_EP

	XREF	App_USB_Reset
	XREF	App_USB_Suspend
	XREF	App_USB_ESuspend
	XREF	App_USB_SOF



APP_VEC:     SECTION
; This section will be placed at a fixed location - the beginning of sector 1
; So that code from sector 0 calls this table for the reference to sector 1
; The order of this table can not be changed once the sector 0 is compiled.

Vec_main:	JP	App_main
VEC_Trap:	JP	INT_Trap
VEC_Plug:	JP	INT_DEVCONINT
VEC_EI0:	JP	INT_EI0
VEC_DTC:	JP	INT_DTC
VEC_EI1:	JP	INT_EI1
VEC_I2C:	JP	INT_I2C
VEC_Timer:	JP	INT_TIM

Vec_App_init:		JP App_init

Vec_USB_Setup:		JP App_USB_Setup
Vec_CopydataIN:		JP App_CopydataIN
Vec_CopydataOUT:	JP App_CopydataOUT
Vec_Set_Configuration:	JP App_Set_Configuration
Vec_Set_Interface:	JP App_Set_Interface
Vec_Get_Interface:	JP App_Get_Interface

Vec_Status_In:		JP App_Status_In
Vec_Status_Out:		JP App_Status_Out

Vec_Set_Feature_Int:	JP App_Set_Feature_Int
Vec_Set_Feature_EP:	JP App_Set_Feature_EP
Vec_Clear_Feature_Int:	JP App_Clear_Feature_Int
Vec_Clear_Feature_EP:	JP App_Clear_Feature_EP

Vec_USB_Reset:		JP App_USB_Reset
Vec_USB_Suspend:	JP App_USB_Suspend
Vec_USB_ESuspend:	JP App_USB_ESuspend
Vec_USB_SOF:		JP App_USB_SOF

            END            
