;********************************************************
;* Project:	ST7265 5in1 Demo with DFU feature	*
;* Version:	V1.0					*
;* Creation:	17/07/2002				*
;* Description:	This module should be in ROM sector 0	*
;*		for the sake of DFU. All interrupt will	*
;*		dispatch to other sectors.		*
;********************************************************

; THIS FILE IS USED TO TEST THE CODE IN SECTOR 0
	XDEF	Vec_main
	XDEF	VEC_Trap
	XDEF	VEC_Plug	; Power Management USB Plug/Unplug
	XDEF	VEC_EI0		; External Interrupt Port A
	XDEF	VEC_DTC		; DTC Peripheral Interrupt
	XDEF	VEC_EI1		; External Interrupt Port D
	XDEF	VEC_I2C		; I 2 C Interrupt
	XDEF	VEC_Timer	; Timer interrupt

	XDEF	Vec_init

	XDEF	Vec_USB_Setup
	XDEF	Vec_CopydataIN
	XDEF	Vec_CopydataOUT
	XDEF	Vec_Set_Configuration
	XDEF	Vec_Set_Interface
	XDEF	Vec_Get_Interface

	XDEF	Vec_Status_In
	XDEF	Vec_Status_Out

	XDEF	Vec_Set_Feature_Int
	XDEF	Vec_Set_Feature_EP
	XDEF	Vec_Clear_Feature_Int
	XDEF	Vec_Clear_Feature_EP

	XDEF	Vec_USB_Reset
	XDEF	Vec_USB_Suspend
	XDEF	Vec_USB_ESuspend
	XDEF	Vec_USB_SOF



APP_VEC:     SECTION
; This section will be placed at a fixed location - the beginning of sector 1
; So that code from sector 0 calls this table for the reference to sector 1
; The order of this table can not be changed once the sector 0 is compiled.

Vec_main:	JP	Vec_main
VEC_Trap:	JP	VEC_Trap
VEC_Plug:	JP	VEC_Plug
VEC_EI0:	JP	VEC_EI0
VEC_DTC:	JP	VEC_DTC
VEC_EI1:	JP	VEC_EI1
VEC_I2C:	JP	VEC_I2C
VEC_Timer:	JP	VEC_Timer

Vec_init:		JP Vec_init

Vec_USB_Setup:		JP Vec_USB_Setup
Vec_CopydataIN:		JP Vec_CopydataIN
Vec_CopydataOUT:	JP Vec_CopydataOUT
Vec_Set_Configuration:	JP Vec_Set_Configuration
Vec_Set_Interface:	JP Vec_Set_Interface
Vec_Get_Interface:	JP Vec_Get_Interface

Vec_Status_In:		JP Vec_Status_In
Vec_Status_Out:		JP Vec_Status_Out

Vec_Set_Feature_Int:	JP Vec_Set_Feature_Int
Vec_Set_Feature_EP:	JP Vec_Set_Feature_EP
Vec_Clear_Feature_Int:	JP Vec_Clear_Feature_Int
Vec_Clear_Feature_EP:	JP Vec_Clear_Feature_EP

Vec_USB_Reset:		JP Vec_USB_Reset
Vec_USB_Suspend:	JP Vec_USB_Suspend
Vec_USB_ESuspend:	JP Vec_USB_ESuspend
Vec_USB_SOF:		JP Vec_USB_SOF

            END            
