/*-*-*-*-*-*-*-*-*-*-* (C) 2000 STMicroelectronics *-*-*-*-*-*-*-*-*-*-*-*-*-*

PROJECT  : ST7265 Media Access Library
COMPILER : ST7 C

MODULE  :  MAL_Func.c
VERSION :  V 1.0 Beta

CREATION DATE :  16/03/2001

AUTHOR : Liang Ping
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

DESCRIPTION : All functions except those with individual one

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

Modification:

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#include "MConfig.h"
#include "MAL_Func.h"

unsigned long Medium_Capacity[MAX_LUN+1];	// the last addres of the medium
extern unsigned char LUN_Config;

extern void MAL_SMC_Funcs();
extern void SMC_DTC_Int();
extern void MAL_MMC_Funcs();
extern void MMC_DTC_Int();
extern void MAL_CFC_Funcs();
extern void CFC_DTC_Int();
extern void MAL_MS_Funcs();
extern void MS_DTC_Int();

#pragma INTO_ROM	MAL_CONST
const void (*MAL_Func[MAX_LUN+1])() = {
#ifdef DFU_DEMO_FLASH_ONLY
	MAL_SMC_Funcs
#else
	MAL_SMC_Funcs,
	MAL_MMC_Funcs,	
	MAL_CFC_Funcs,
	MAL_SMC_Funcs,
	MAL_MS_Funcs
#endif
};

#pragma INTO_ROM
const void (*MAL_DTC_Int[MAX_LUN+1])() = {
#ifdef DFU_DEMO_FLASH_ONLY
	SMC_DTC_Int
#else
	SMC_DTC_Int,
	MMC_DTC_Int,	
	CFC_DTC_Int,
	SMC_DTC_Int,
	MS_DTC_Int
#endif
};
