#ifndef MCONFIG_H
#define MCONFIG_H

#ifdef DFU_DEMO_FLASH_ONLY
#define MAX_LUN		0
#define USE_FLASH
#else
#define MAX_LUN		4
#define USE_SMC
#define USE_MMC
#define USE_CF
#define USE_FLASH
#define USE_SONY
#endif

//#define USE_LUN_CONFIG

#ifdef USE_SMC
#define SMC_INDEX	0
#endif

#ifdef USE_MMC
#define MMC_INDEX	1
#endif

#ifdef USE_CF
#define CF_INDEX	2
#endif

#ifdef USE_SONY
#define SONY_INDEX	4
#endif

#ifdef USE_FLASH
#ifdef DFU_DEMO_FLASH_ONLY
#define FLASH_INDEX	0
#else
#define FLASH_INDEX	3
#endif
#endif

#define	SELECT()				select()
#define	DESELECT()				deselect()
unsigned char isWrite_Protect();
#define	isWRITE_PROTECT()	isWrite_Protect()
#define	MEDIUM_LOCK(index)		1
#define	MEDIUM_UNLOCK(index)	1
#define	isMEDIUM_LOCK(index)	1

#define MAL_POWER_ON { PCR |= 0x01; PEDR |= 0x08; }
//#define MAL_POWER_ON { PCR &= ~0x01; PEDR |= 0x08; }
#define MAL_POWER_OFF { PCR &= ~0x01; PEDR &= ~0x08; }

#pragma DATA_SEG DEFAULT

#endif