/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_def.c
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	02/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	This header file defines constants used in the library
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#ifndef USBDEFINE_H
#define USBDEFINE_H

// USB Request type
#define REQ_TYPE_STANDARD	0x00
#define REQ_TYPE_CLASS		0x20
#define	REQ_TYPE_VENDOR		0x40
#define REQ_TYPE_OTHER		0x60
#define REQ_TYPE_MASK		0x60

// USB Request Recipient
#define RECIPIENT_DEVICE	0x00
#define RECIPIENT_INTERFACE	0x01
#define RECIPIENT_ENDPOINT	0x02
#define RECIPIENT_MASK		0x1F

// USB standard bRequest value
#define GET_STATUS			0
#define CLEAR_FEATURE		1
#define SET_OUTPUT			2
#define SET_FEATURE			3
#define SET_ADDRESS			5
#define GET_DESCRIPTOR		6
#define SET_DESCRIPTOR		7
#define GET_CONFIGURATION	8
#define SET_CONFIGURATION	9
#define GET_INTERFACE		0x0A
#define SET_INTERFACE		0x0B
#define SYNCH_FRAME			0x0C

/******************************************************************************/

// Defines for USB_vSetup structure 
#define	REQ_ERROR			0			// Error on process
#define	REQ_SUCCESS			2			// Process sucessfully
#define	REQ_UNSUPPORT		4			// request unsupported, false EP,etc...

#endif

/**************** (c) 2000  STMicroelectronics **********************/
