/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_ep3.c
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	02/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
		Functions for sending and/or receiving data from/to EP3
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/
#include "mcu_conf.h"
#include "usb_reg.h"
#include "usb_def.h"
#include "usb_libs.h"
#include "usb_lib.h"

//#ifdef	DECLARE_EP3

//extern unsigned char _EP_RxTx_Flag;	// D4=0: Transmiter is free
									// D4=1: Transmiter is busy
#pragma DATA_SEG USB_RAM
static unsigned char *EP3_XBuffer;	// Current pointer to transmit buffer
static unsigned char EP3_XLength;	// Remain length to be sent

#pragma CODE_SEG USB_CODE 
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_SendDataEP3
INPUT/OUTPUT : *DataAddress: points to the buffer to be sent
			   Length: gives the length of data to be sent. Range is 1-255
RETURN       : REQ_ERROR if the transmitter is busy
			   REQ_SUCCESS if the transmit starts correctly
DESCRIPTION  : Transmit "Length" data from the given buffer to host PC
-----------------------------------------------------------------------------*/
char _USB_SendDataEP3(void)
{
	if (ValBit(_EP_RxTx_Flag, EV_EP3_IN))		// Check if the transmitter is busy
		return REQ_ERROR;
	if ((EP3TXR & EP_GOOD) == 0)				// Check if the EP is in DISABLE or STALL
		return REQ_ERROR;

	if (EPs_Length > MAX_EP3_PACKET_SIZE) {
		EP3_XLength = EPs_Length - MAX_EP3_PACKET_SIZE;	// Bytes remain to xmit
		EP3_XBuffer = EPs_DataAddress + MAX_EP3_PACKET_SIZE;	// Address for the next xmit
		asm LD		X, #MAX_EP3_PACKET_SIZE;		// Bytes to copy to EP buffer
	}
	else {
		EP3_XLength = 0;						// All data can be sent in one shot
		asm LD		X, EPs_Length;			// Bytes to copy to EP buffer
	}

	asm {										// Copy data to EP buffer
		LD		CNT3TXR, X
		DEC		X
		LD		A, EPs_DataAddress
		LD		_LEX, A
		LD		A, EPs_DataAddress:1
		LD		_LEX:1, A
loop_copy:
		LD		A, ([_LEX.w], X)
		LD		(EP3_IN, X), A
		DEC		X
		JRPL	loop_copy
	}

	SetBit(_EP_RxTx_Flag, EV_EP3_IN);
	USB_SetTxEP3Status(EP_VALID);
	return REQ_SUCCESS;
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP3_isSent
RETURN       : Non-zero if the data is sent on EP3
DESCRIPTION  : This function is called to enquire if the data is sent on EP3
-----------------------------------------------------------------------------*/
//char USB_EP3_isSent(void)
//{
//	return !ValBit(_EP_RxTx_Flag, EV_EP3_IN);
//}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP3_XEvent
DESCRIPTION  : This function is called when there is a USB CTR on EP3 transmitter
WARNING      : This function may be called from interrupt routine
-----------------------------------------------------------------------------*/
void _USB_EP3_XEvent(void)
{
	if (EP3_XLength == 0) {
		ClrBit(_EP_RxTx_Flag, EV_EP3_IN);		// Finish sending if there is no remain data
		return;
	}

	if (EP3_XLength > MAX_EP3_PACKET_SIZE) {	// If more than one packet to send
		EP3_XLength -= MAX_EP3_PACKET_SIZE;		// Descrease number of remain bytes
		EP3_XBuffer += MAX_EP3_PACKET_SIZE;		// Increase sending pointer for next send
		asm LD		X, #MAX_EP3_PACKET_SIZE;	// Number of bytes to copy to EP buffer
	}
	else {
		asm LD		X, EP3_XLength;				// Number of bytes to copy to EP buffer
		EP3_XLength = 0;						// All data can be sent in one shot
	}

	asm {										// Copy data from user buffer to EP buffer
		LD		A, EP3_XBuffer
		LD		_LEX, A
		LD		A, EP3_XBuffer:1
		LD		_LEX:1, A

		LD		CNT3TXR, X
		DEC		X
loop_copy:
		LD		A, ([_LEX.w], X)
		LD		(EP3_IN, X), A
		DEC		X
		JRPL	loop_copy
	}

	USB_SetTxEP3Status(EP_VALID);
}

//#endif	//DECLARE_EP3
