/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_ep5.c
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	02/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
		Functions for sending and/or receiving data from/to EP5
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/
#include "mcu_conf.h"
#include "usb_reg.h"
#include "usb_def.h"
#include "usb_libs.h"
#include "usb_lib.h"

//#ifdef	DECLARE_EP5

//extern unsigned char _EP_RxTx_Flag;	// D6=0: Transmiter is free
									// D6=1: Transmiter is busy
#pragma DATA_SEG USB_RAM
static unsigned char *EP5_XBuffer;	// Current pointer to transmit buffer
static unsigned char EP5_XLength;	// Remain length to be sent

#pragma CODE_SEG USB_CODE 
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_SendDataEP5
INPUT/OUTPUT : *DataAddress: points to the buffer to be sent
			   Length: gives the length of data to be sent. Range is 1-255
RETURN       : REQ_ERROR if the transmitter is busy
			   REQ_SUCCESS if the transmit starts correctly
DESCRIPTION  : Transmit "Length" data from the given buffer to host PC
-----------------------------------------------------------------------------*/
char _USB_SendDataEP5()
{
	if (ValBit(_EP_RxTx_Flag, EV_EP5_IN))		// Check if the transmitter is busy
		return REQ_ERROR;
	if ((EP5TXR & EP_GOOD) == 0)				// Check if the EP is in DISABLE or STALL
		return REQ_ERROR;

	if (EPs_Length > MAX_EP5_PACKET_SIZE) {
		EP5_XLength = EPs_Length - MAX_EP5_PACKET_SIZE;	// Bytes remain to xmit
		EP5_XBuffer = EPs_DataAddress + MAX_EP5_PACKET_SIZE;	// Address for the next xmit
		asm LD		X, #MAX_EP5_PACKET_SIZE;		// Bytes to copy to EP buffer
	}
	else {
		EP5_XLength = 0;						// All data can be sent in one shot
		asm LD		X, EPs_Length;			// Bytes to copy to EP buffer
	}

	asm {										// Copy data to EP buffer
		LD		CNT5TXR, X
		DEC		X
		LD		A, EPs_DataAddress
		LD		_LEX, A
		LD		A, EPs_DataAddress:1
		LD		_LEX:1, A
loop_copy:
		LD		A, ([_LEX.w], X)
		LD		(EP5_IN, X), A
		DEC		X
		JRPL	loop_copy
	}

	SetBit(_EP_RxTx_Flag, EV_EP5_IN);
	USB_SetTxEP5Status(EP_VALID);
	return REQ_SUCCESS;
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP5_isSent
RETURN       : Non-zero if the data is sent on EP5
DESCRIPTION  : This function is called to enquire if the data is sent on EP5
-----------------------------------------------------------------------------*/
//char USB_EP5_isSent(void)
//{
//	return !ValBit(_EP_RxTx_Flag, EV_EP5_IN);
//}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP5_XEvent
DESCRIPTION  : This function is called when there is a USB CTR on EP5 transmitter
WARNING      : This function may be called from interrupt routine
-----------------------------------------------------------------------------*/
void _USB_EP5_XEvent(void)
{
	if (EP5_XLength == 0) {
		ClrBit(_EP_RxTx_Flag, EV_EP5_IN);		// Finish sending if there is no remain data
		return;
	}

	if (EP5_XLength > MAX_EP5_PACKET_SIZE) {	// If more than one packet to send
		EP5_XLength -= MAX_EP5_PACKET_SIZE;		// Descrease number of remain bytes
		EP5_XBuffer += MAX_EP5_PACKET_SIZE;		// Increase sending pointer for next send
		asm LD		X, #MAX_EP5_PACKET_SIZE;	// Number of bytes to copy to EP buffer
	}
	else {
		asm LD		X, EP5_XLength;				// Number of bytes to copy to EP buffer
		EP5_XLength = 0;						// All data can be sent in one shot
	}

	asm {										// Copy data from user buffer to EP buffer
		LD		A, EP5_XBuffer
		LD		_LEX, A
		LD		A, EP5_XBuffer:1
		LD		_LEX:1, A

		LD		CNT5TXR, X
		DEC		X
loop_copy:
		LD		A, ([_LEX.w], X)
		LD		(EP5_IN, X), A
		DEC		X
		JRPL	loop_copy
	}

	USB_SetTxEP5Status(EP_VALID);
}

//#endif	//DECLARE_EP5

