/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_eps.c
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	02/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
		All functions from the USB library for non-control pipe
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#ifndef DEFINE_EPS_H
#define DEFINE_EPS_H

#pragma DATA_SEG USB_RAM
extern unsigned char *EPs_DataAddress;
extern unsigned char EPs_Length;

#pragma CODE_SEG USB_CALL

#ifdef	DECLARE_EP1
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_SendDataEP1
INPUT/OUTPUT : *DataAddress: points to the buffer to be sent
			   Length: gives the length of data to be sent. Range is 1-255
RETURN       : REQ_ERROR if the transmitter is busy
			   REQ_SUCCESS if the transmit starts correctly
DESCRIPTION  : Transmit "Length" data from the given buffer to host PC
-----------------------------------------------------------------------------*/
char _USB_SendDataEP1(void);
unsigned char USB_SendDataEP1(unsigned char *dp, unsigned char len);

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP1_isSent
RETURN       : Non-zero if the data is sent on EP1
DESCRIPTION  : This function is called to enquire if the data is sent on EP1
-----------------------------------------------------------------------------*/
#define USB_EP1_isSent()	(!ValBit(_EP_RxTx_Flag, EV_EP1_IN))

#ifdef	MCU_ST7265
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_RecvDataEP1
INPUT/OUTPUT : "DataAddress" is the buffer to receive the data
			   "Length" is the size of the buffer
RETURN       : REQ_ERROR if the receiver is busy
			   REQ_SUCCESS if the receiving starts correctly
DESCRIPTION  : Enable the receiver and receive the data to the buffer
			   Use USB_TakeDataEP1() to check if the receiving is finished
-----------------------------------------------------------------------------*/
char _USB_RecvDataEP1(void);
unsigned char USB_RecvDataEP1(unsigned char *dp, unsigned char len);

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_TakeDataEP1
INPUT/OUTPUT : none
RETURN       : 0xFF if the receiving does not finish
			   otherwise the number of actual received bytes
DESCRIPTION  : check if the receiving finishes
-----------------------------------------------------------------------------*/
unsigned char USB_TakeDataEP1(void);

#endif	// MCU_ST7265
#endif	// DECLARE_EP1

#ifdef	DECLARE_EP2
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_SendDataEP2
INPUT/OUTPUT : *DataAddress: points to the buffer to be sent
			   Length: gives the length of data to be sent. Range is 1-155
RETURN       : REQ_ERROR if the transmitter is busy
			   REQ_SUCCESS if the transmit starts correctly
DESCRIPTION  : Transmit "Length" data from the given buffer to host PC
-----------------------------------------------------------------------------*/
char _USB_SendDataEP2(void);
unsigned char USB_SendDataEP2(unsigned char *dp, unsigned char len);

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP2_isSent
RETURN       : Non-zero if the data is sent on EP2
DESCRIPTION  : This function is called to enquire if the data is sent on EP2
-----------------------------------------------------------------------------*/
#define USB_EP2_isSent()	(!ValBit(_EP_RxTx_Flag, EV_EP2_IN))

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_RecvDataEP2
INPUT/OUTPUT : "DataAddress" is the buffer to receive the data
			   "Length" is the size of the buffer
RETURN       : REQ_ERROR if the receiver is busy
			   REQ_SUCCESS if the receiving starts correctly
DESCRIPTION  : Enable the receiver and receive the data to the buffer
			   Use USB_TakeDataEP2() to check if the receiving is finished
-----------------------------------------------------------------------------*/
char _USB_RecvDataEP2(void);
unsigned char USB_RecvDataEP2(unsigned char *dp, unsigned char len);

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_TakeDataEP2
INPUT/OUTPUT : none
RETURN       : 0xFF if the receiving does not finish
			   otherwise the number of actual received bytes
DESCRIPTION  : check if the receiving finishes
-----------------------------------------------------------------------------*/
unsigned char USB_TakeDataEP2(void);
#endif	// DECLARE_EP2

#ifdef	MCU_ST7SCR
#ifdef	DECLARE_EP3
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_SendDataEP3
INPUT/OUTPUT : *DataAddress: points to the buffer to be sent
			   Length: gives the length of data to be sent. Range is 1-155
RETURN       : REQ_ERROR if the transmitter is busy
			   REQ_SUCCESS if the transmit starts correctly
DESCRIPTION  : Transmit "Length" data from the given buffer to host PC
-----------------------------------------------------------------------------*/
char _USB_SendDataEP3(void);
unsigned char USB_SendDataEP3(unsigned char *dp, unsigned char len);

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP3_isSent
RETURN       : Non-zero if the data is sent on EP3
DESCRIPTION  : This function is called to enquire if the data is sent on EP3
-----------------------------------------------------------------------------*/
#define USB_EP3_isSent()	(!ValBit(_EP_RxTx_Flag, EV_EP3_IN))
#endif	// DECLARE_EP3

#ifdef	DECLARE_EP4
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_SendDataEP4
INPUT/OUTPUT : *DataAddress: points to the buffer to be sent
			   Length: gives the length of data to be sent. Range is 1-155
RETURN       : REQ_ERROR if the transmitter is busy
			   REQ_SUCCESS if the transmit starts correctly
DESCRIPTION  : Transmit "Length" data from the given buffer to host PC
-----------------------------------------------------------------------------*/
char _USB_SendDataEP4(void);
unsigned char USB_SendDataEP4(unsigned char *dp, unsigned char len);

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP4_isSent
RETURN       : Non-zero if the data is sent on EP4
DESCRIPTION  : This function is called to enquire if the data is sent on EP4
-----------------------------------------------------------------------------*/
#define USB_EP4_isSent()	(!ValBit(_EP_RxTx_Flag, EV_EP4_IN))
#endif	// DECLARE_EP4

#ifdef	DECLARE_EP5
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_SendDataEP5
INPUT/OUTPUT : *DataAddress: points to the buffer to be sent
			   Length: gives the length of data to be sent. Range is 1-155
RETURN       : REQ_ERROR if the transmitter is busy
			   REQ_SUCCESS if the transmit starts correctly
DESCRIPTION  : Transmit "Length" data from the given buffer to host PC
-----------------------------------------------------------------------------*/
char _USB_SendDataEP5(void);
unsigned char USB_SendDataEP5(unsigned char *dp, unsigned char len);

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP5_isSent
RETURN       : Non-zero if the data is sent on EP5
DESCRIPTION  : This function is called to enquire if the data is sent on EP5
-----------------------------------------------------------------------------*/
#define USB_EP5_isSent()	(!ValBit(_EP_RxTx_Flag, EV_EP5_IN))
#endif	// DECLARE_EP5
#endif	// MCU_ST7SCR

#endif	// DEFINE_EPS_H
