/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_ep3.c
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	04/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
		Functions for control embedded HUB function
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/
#include <setjmp.h>
#include "mcu_conf.h"
#include "usb_lib.h"
#include "usb_libs.h"

#pragma DATA_SEG USB_RAM
#ifdef	MCU_ST7HUB
static jmp_buf	usb_port;
#endif

#pragma CODE_SEG USB_CODE

void Init_HUB(void)
{
#ifdef	MCU_ST7HUB
	HUBVIDHR = HUB_VID >> 8;
	HUBVIDLR = HUB_VID;
	HUBPIDHR = HUB_PID >> 8;
	HUBPIDLR = HUB_PID;

	HUBCR = 0x40 |
#ifdef	HUB_EXT_PWCTL
		0x02 |
#endif
#ifdef	HUB_SELF_POWER
		0x04 |
#endif
		0x01;

	setjmp(usb_port);
	asm RIM;			// Enable interrupt

	USBIMR = 0;			// Turn off all embedded USB interrupt
	USBCTLR = 0x06;		// No-force USB reset and Power off 3.3V regulator

	while ((HUBCR & 0x80) == 0);	// wait the embedded function is powered

	// Enable interrupt on reset only
	// When device powered on, a power on reset is triggered
	// After the device is powered, the device will connect to the bus
	// After device connect to the bus, a reset will be received from the host
	// This final reset will enable the USB functions.
	USBIMR = 0x02;		// IMR_RESET;
	USBCTLR = 0x00;		// clear the reset bit and connect the device

	// After host reset the function, Init_USB() is called
	// In Init_USB(), the receiving of EP0 is enabled
	// Wait EP0 is enabled to continue
	while ((EP0R & 0x03) == 0);
#endif
}

#pragma TRAP_PROC // SAVE_REGS
void INT_HUB(void)
{
#ifdef	MCU_ST7HUB
	if ((HUBCR & 0x80) == 0) {
		// the embedded function is un-powered
		Init_Application();
		longjmp(usb_port, 0);
	}
#endif
}
