/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_libs.c
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	02/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
		Functions used inside the USB library
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS:

******************************************************************************/

#ifndef	USBLIBS_DEFINE_H
#define USBLIBS_DEFINE_H

#define SetBit(var, bit)	var |= (1 << bit)
#define ClrBit(var, bit)	var &= ~(1 << bit)
#define ValBit(var, bit)	(var & (1 << bit))

#ifdef	DECLARE_EP1
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP1_XEvent
DESCRIPTION  : This function is called when there is a USB CTR on EP1 transmitter
-----------------------------------------------------------------------------*/
void _USB_EP1_XEvent(void);

#ifdef	MCU_ST7265
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP1_REvent
DESCRIPTION  : This function is called when there is a USB CTR on EP1 receiver
WARNING      : This function may be called from interrupt routine
-----------------------------------------------------------------------------*/
void _USB_EP1_REvent(void);
#endif
#endif	//DECLARE_EP1

#ifdef	DECLARE_EP2
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP2_XEvent
DESCRIPTION  : This function is called when there is a USB CTR on EP2 transmitter
-----------------------------------------------------------------------------*/
void _USB_EP2_XEvent(void);

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP2_REvent
DESCRIPTION  : This function is called when there is a USB CTR on EP2 receiver
WARNING      : This function may be called from interrupt routine
-----------------------------------------------------------------------------*/
void _USB_EP2_REvent(void);
#endif

#ifdef	MCU_ST7SCR
#ifdef	DECLARE_EP3
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP3_XEvent
DESCRIPTION  : This function is called when there is a USB CTR on EP3 transmitter
-----------------------------------------------------------------------------*/
void _USB_EP3_XEvent(void);
#endif

#ifdef	DECLARE_EP4
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP4_XEvent
DESCRIPTION  : This function is called when there is a USB CTR on EP4 transmitter
-----------------------------------------------------------------------------*/
void _USB_EP4_XEvent(void);
#endif

#ifdef	DECLARE_EP5
/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_EP5_XEvent
DESCRIPTION  : This function is called when there is a USB CTR on EP5 transmitter
-----------------------------------------------------------------------------*/
void _USB_EP5_XEvent(void);
#endif
#endif	// MCU_ST7SCR

#endif	// USBLIBS_DEFINE_H
