/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_def.c
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	02/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	This header file defines constants when using the library
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#ifndef	USBREGISTER_H
#define	USBREGISTER_H

// Endpoint Register (EPnR)
#define EP_DISABLE			0x00		// DISABLE mask
#define EP_STALL			0x01		// STALL mask
#define EP_NAK				0x02		// NAK mask
#define EP_VALID			0x03		// VALID mask
#define EP_GOOD				0x02		// The endpoint can be used

// Bit definitions of USBISTR and USBIMR
#define ISTR_CTR		7				// Correct Transfter
#define ISTR_SOVR		5				// Setup Overrun
#define ISTR_ERR		4				// Error
#define ISTR_SUSP		3				// Suspend mode request
#define ISTR_ESUSP		2				// End suspend mode
#define ISTR_RESET		1				// Reset
#define ISTR_SOF		0				// Start of Frame

#define IMR_CTR			(1 << ISTR_CTR)
#define IMR_SOVR		(1 << ISTR_SOVR)
#define IMR_ERR			(1 << ISTR_ERR)
#define IMR_SUSP		(1 << ISTR_SUSP)
#define IMR_ESUSP		(1 << ISTR_ESUSP)
#define IMR_RESET		(1 << ISTR_RESET)
#define IMR_SOF			(1 << ISTR_SOF)

#endif	//	USBREGISTER_H
