/**************** (c) 2000  STMicroelectronics **********************

PROJECT : USB - ST7 FULL SPEED

VERSION :  v 0.96

CREATION DATE :  01/12/2000

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/


#include "mcu_conf.h"
#include "usb_lib.h"

#include "lib_bits.h"
#include "MAL_Func.h"
#include "Mconfig.h"


unsigned char Max_Lun;
unsigned char LUN_Config;

char USER_DATA_Received[8];
char USER_LENGTH_Receive[1]; 

#pragma CODE_SEG APPLI_CODE

/*-----------------------------------------------------------------------------
ROUTINE NAME : Init_port
INPUT/OUTPUT : None
DESCRIPTION  : Init the port 
-----------------------------------------------------------------------------*/
void Init_port(void)
{
//------------------ I/O ports initialization ----------

	// Port A
	ClrBit(PADDR,6);	// PA6 Input : CF CD
	ClrBit(PADDR,7);	// PA7 Input : SMC WP
	
	// Port C
	ClrBit(PCDDR,0);	// PC0 Input : Sony Stick CD	
	ClrBit(PCDDR,4);	// PC4 Input : SMC CD
	ClrBit(PCDDR,5);	// PC5 Input : SD CD
	ClrBit(PCDDR,6);	// PC6 Input : SD WP
	SetBit(PCOR,7);		// PC7 Push Pull : LED1
	SetBit(PCDDR,7);	// PC7 Output : LED1
	
	// Port D
	SetBit(PDOR,0);		// PD0 Push Pull : LED2
	SetBit(PDOR,1);		// PD1 Push Pull : LED3
	SetBit(PDOR,2);		// PD2 Push Pull : LED4
	SetBit(PDOR,3);		// PD3 Push Pull : LED5
	SetBit(PDOR,4);		// PD4 Push Pull : LED6
	SetBit(PDOR,5);		// PD5 Push Pull : LED7
	SetBit(PDOR,6);		// PD6 Push Pull : LED8
	SetBit(PDOR,7);		// PD7 Push Pull : LED9
	
	SetBit(PDDDR,0);	// PD0 Output : LED2
	SetBit(PDDDR,1);	// PD1 Output : LED3
	SetBit(PDDDR,2);	// PD2 Output : LED4
	SetBit(PDDDR,3);	// PD3 Output : LED5
	SetBit(PDDDR,4);	// PD4 Output : LED6
	SetBit(PDDDR,5);	// PD5 Output : LED7
	SetBit(PDDDR,6);	// PD6 Output : LED8
	SetBit(PDDDR,7);	// PD7 Output : LED9	
	
	// Port E
	ClrBit(PEOR,0);		// PE0 Open Drain : NAND CE
	ClrBit(PEOR,1);		// PE1 Open Drain : SMC CE
	ClrBit(PEOR,2);		// PE2 Open Drain : CF CE
	SetBit(PEOR,3);		// PE3 Push Pull : POWER
	SetBit(PEOR,4);		// PE4 Push Pull : ICC
	SetBit(PEDDR,0);	// PE0 Output : NAND CE
	SetBit(PEDDR,1);	// PE1 Output : SMC CE
	SetBit(PEDDR,2);	// PE2 Output : CF CE
	SetBit(PEDDR,3);	// PE3 Output : POWER
	SetBit(PEDDR,4);	// PE4 Output : ICC
	
	// Port F
	ClrBit(PFDDR,2);	// PF2 Input : SLOT1
	ClrBit(PFDDR,3);	// PF3 Input : SLOT2
	ClrBit(PFDDR,4);	// PF4 Input : SLOT3
	ClrBit(PFDDR,5);	// PF5 Input : SLOT4
	ClrBit(PFDDR,6);	// PF6 Input : SLOT5
	
	PEDR |= 0x01;		// PE0 : NAND CE = 1
	PEDR |= 0x02;		// PE1 : SMC CE = 1
	PEDR |= 0x04;		// PE2 : CF CE = 1
	PEDR |= 0x08;		// PE3 : POWER = 1
	PEDR |= 0x10;		// PE4 : ICC = 1
	PCDR |= 0x80;		// PC7 : LED1 = 1
	PDDR |= 0xFF;		// LEDs OFF
};

void App_init(void)
{
	MAL_POWER_ON;
// Delay to let regulator stable	
	asm {
		CLR	X
delay:	NOP
		DEC	X
		JRNE delay
	}
	Init_port();
	
#ifdef USE_LUN_CONFIG
	LUN_Config = (PFDR & 0x7C);
	
	if ((LUN_Config == 0x04) || (LUN_Config == 0x08) || (LUN_Config == 0x10) ||
	 (LUN_Config == 0x20) || (LUN_Config == 0x40))
		Max_Lun = 0;
	else if ((LUN_Config == 0x0C) || (LUN_Config == 0x14) || (LUN_Config == 0x24) ||
	 (LUN_Config == 0x44) || (LUN_Config == 0x18) || (LUN_Config == 0x28) ||
	 (LUN_Config == 0x48) || (LUN_Config == 0x30) || (LUN_Config == 0x50) ||
	 (LUN_Config == 0x60))
	 	Max_Lun = 1;
	else if ((LUN_Config == 0x1C) || (LUN_Config == 0x2C) || (LUN_Config == 0x4C) ||
	 (LUN_Config == 0x34) || (LUN_Config == 0x54) || (LUN_Config == 0x64) ||
	 (LUN_Config == 0x38) || (LUN_Config == 0x58) || (LUN_Config == 0x68) ||
	 (LUN_Config == 0x70))
	 	Max_Lun = 2;
	if ((LUN_Config == 0x3C) || (LUN_Config == 0x5C) || (LUN_Config == 0x6C) ||
	 (LUN_Config == 0x74) || (LUN_Config == 0x78))
		Max_Lun = 3;
	if (LUN_Config == 0x7C)
		Max_Lun = 4;
#else
	Max_Lun = MAX_LUN;
#endif
}

void USER_Application(void)
{
#ifdef USE_LUN_CONFIG

if (ValBit(PFDR,2)) {		// SLOT1 present

	/*******  SMC   *******/
	if (!ValBit(PCDR,4)) {		//SMC Card Detect
		MAL_Medium_Plug(SMC_INDEX);		// To simulate that slot 0 has medium
		PDDR &= ~0x01;	// PD0 Output : LED2
	}
	else {
		MAL_Medium_Removing(SMC_INDEX);
		PDDR |= 0x01;	// PD0 Output : LED2
	}
}
	
if (ValBit(PFDR,3)) {		// SLOT2 present

	/*******  MMC   *******/
	if (!ValBit(PCDR,5)) {		//MMC Card Detect
		MAL_Medium_Plug(MMC_INDEX);		// To simulate that slot 1 has medium
		PDDR &= ~0x04;	// PD2 Output : LED4
	}
	else {
		MAL_Medium_Removing(MMC_INDEX);
		PDDR |= 0x04;	// PD2 Output : LED4
	}
}

if (ValBit(PFDR,4)) {		// SLOT3 present

	/*******  CF   *******/
	if (!ValBit(PADR,6)) {		//CF Card Detect
		MAL_Medium_Plug(CF_INDEX);		// To simulate that slot 0 has medium
		PDDR &= ~0x10;	// PD4 Output : LED6
	}
	else {
		MAL_Medium_Removing(CF_INDEX);
		PDDR |= 0x10;	// PD4 Output : LED6
	}
}
	
if (ValBit(PFDR,5)) {		// SLOT4 present

	/*******  SONY   *******/
	if (!ValBit(PCDR,5)) {		//SONY Card Detect
		MAL_Medium_Plug(SONY_INDEX);		// To simulate that slot 1 has medium
		PDDR &= ~0x40;	// PD6 Output : LED8
	}
	else {
		MAL_Medium_Removing(SONY_INDEX);
		PDDR |= 0x40;	// PD6 Output : LED8
	}

if (ValBit(PFDR,6)) {		// SLOT5 present

	/*******  FLASH   *******/
	MAL_Medium_Plug(FLASH_INDEX);		// To simulate that slot 0 has medium
}

#else
// LUN_CONFIG not used
#ifdef USE_SMC
	/*******  SMC   *******/
	if (!ValBit(PCDR,4)) {		//SMC Card Detect
		MAL_Medium_Plug(SMC_INDEX);		// To simulate that slot 0 has medium
		PDDR &= ~0x01;	// PD0 Output : LED2
	}
	else {
		MAL_Medium_Removing(SMC_INDEX);
		PDDR |= 0x01;	// PD0 Output : LED2
	}
#endif
	
#ifdef USE_MMC
	/*******  MMC   *******/
	if (!ValBit(PCDR,5)) {		//MMC Card Detect
		MAL_Medium_Plug(MMC_INDEX);		// To simulate that slot 1 has medium
		PDDR &= ~0x04;	// PD2 Output : LED4
	}
	else {
		MAL_Medium_Removing(MMC_INDEX);
		PDDR |= 0x04;	// PD2 Output : LED4
	}
#endif

#ifdef USE_CF
	/*******  CF   *******/
	if (!ValBit(PADR,6)) {		//CF Card Detect
		MAL_Medium_Plug(CF_INDEX);		// To simulate that slot 0 has medium
		PDDR &= ~0x10;	// PD4 Output : LED6
	}
	else {
		MAL_Medium_Removing(CF_INDEX);
		PDDR |= 0x10;	// PD4 Output : LED6
	}
#endif
	
#ifdef USE_SONY
	/*******  SONY   *******/
	if (!ValBit(PCDR,0)) {		//SONY Card Detect
		MAL_Medium_Plug(SONY_INDEX);		// To simulate that slot 1 has medium
		PDDR &= ~0x40;	// PD6 Output : LED8
	}
	else {
		MAL_Medium_Removing(SONY_INDEX);
		PDDR |= 0x40;	// PD6 Output : LED8
	}
#endif

#ifdef USE_FLASH
	MAL_Medium_Plug(FLASH_INDEX);		// To simulate that slot 0 has medium
#endif
#endif
}

void App_USB_Suspend(void)
{
	MAL_POWER_OFF;
	PEDR &= ~0x01;		// PE0 : NAND CE = 0
	PEDR &= ~0x02;		// PE1 : SMC CE = 0
	PEDR &= ~0x04;		// PE2 : CF CE = 0
	PEDR &= ~0x08;		// PE3 : POWER = 0
	PEDR |= 0x10;		// PE4 : ICC = 1
	PCDR |= 0x80;		// PC7 : LED1 = 1
	PDDR |= 0xFF;		// LEDs OFF
}

void App_USB_ESuspend(void)
{
		MAL_POWER_ON;
// Delay to let regulator stable	
	asm {
		CLR	X
delay:	NOP
		DEC	X
		JRNE delay
	}

	PEDR |= 0x01;		// PE0 : NAND CE = 1
	PEDR |= 0x02;		// PE1 : SMC CE = 1
	PEDR |= 0x04;		// PE2 : CF CE = 1
	PEDR |= 0x08;		// PE3 : POWER = 1
	PEDR |= 0x10;		// PE4 : ICC = 1
	PCDR |= 0x80;		// PC7 : LED1 = 1
	PDDR |= 0xFF;		// LEDs OFF
}

extern unsigned char MAL_Mediano;
void select()
{	
#ifdef USE_LUN_CONFIG
	switch (MAL_Mediano) {

	case 0:		// Select Medium_0
		if (LUN_Config & 0x04){
		// SMC
			PEDR &= ~0x02;	// PE1 : SMC CE = 0
			PCDR &= ~0x80;	// PC7 Output : LED1
		}
		else if (LUN_Config & 0x08){
		// SD
			PDDR &= ~0x02;	// PD1 Output : LED3
		}
		else if (LUN_Config & 0x10){
		// FLASH
			PEDR &= ~0x01;	// PE0 : NAND CE = 0
			PDDR &= ~0x80;	// PD7 Output : LED9
		}
		else if (LUN_Config & 0x20){
		// CF
			PEDR &= ~0x04;	// PE2 : CF CE = 0
			PDDR &= ~0x08;	// PD3 Output : LED5
		}
		else if (LUN_Config & 0x40){
		// SONY
			PDDR &= ~0x20;	// PD5 Output : LED7
		}
		break;

	case 1:		// Select Medium_1
		if (LUN_Config & 0x08){
		// SD
			PDDR &= ~0x02;	// PD1 Output : LED3
		}
		else if (LUN_Config & 0x10){
		// FLASH
			PEDR &= ~0x01;	// PE0 : NAND CE = 0
			PDDR &= ~0x80;	// PD7 Output : LED9
		}
		else if (LUN_Config & 0x20){
		// CF
			PEDR &= ~0x04;	// PE2 : CF CE = 0
			PDDR &= ~0x08;	// PD3 Output : LED5
		}
		else if (LUN_Config & 0x40){
		// SONY
			PDDR &= ~0x20;	// PD5 Output : LED7
		}
		break;

	case 2:		// Select Medium_2
		if (LUN_Config & 0x10){
		// FLASH
			PEDR &= ~0x01;	// PE0 : NAND CE = 0
			PDDR &= ~0x80;	// PD7 Output : LED9
		}
		else if (LUN_Config & 0x20){
		// CF
			PEDR &= ~0x04;	// PE2 : CF CE = 0
			PDDR &= ~0x08;	// PD3 Output : LED5
		}
		else if (LUN_Config & 0x40){
		// SONY
			PDDR &= ~0x20;	// PD5 Output : LED7
		}
		break;

	case 3:		// Select Medium_3
		if (LUN_Config & 0x20){
		// CF
			PEDR &= ~0x04;	// PE2 : CF CE = 0
			PDDR &= ~0x08;	// PD3 Output : LED5
		}
		else if (LUN_Config & 0x40){
		// SONY
			PDDR &= ~0x20;	// PD5 Output : LED7
		}
		break;

	case 4:		// Select Medium_4
		// SONY
		PDDR &= ~0x20;	// PD5 Output : LED7
		break;

	default:
		break;
	}
#else
	switch (MAL_Mediano) {
#ifdef USE_SMC	
	case SMC_INDEX:		// Select Medium_0
		PEDR &= ~0x02;	// PE1 : SMC CE = 0
		PCDR &= ~0x80;	// PC7 Output : LED1
		break;
#endif

#ifdef USE_MMC
	case MMC_INDEX:		// Select Medium_1
		PDDR &= ~0x02;	// PD1 Output : LED3
		break;
#endif

#ifdef USE_CF
	case CF_INDEX:		// Select Medium_0
		PEDR &= ~0x04;	// PE2 : CF CE = 0
		PDDR &= ~0x08;	// PD3 Output : LED5
		break;
#endif

#ifdef USE_SONY
	case SONY_INDEX:		// Select Medium_1
		PDDR &= ~0x20;	// PD5 Output : LED7
		break;
#endif

#ifdef USE_FLASH
	case FLASH_INDEX:		// Select Medium_1
		PEDR &= ~0x01;	// PE0 : NAND CE = 0
		PDDR &= ~0x80;	// PD7 Output : LED9
		break;
#endif
	default:
		break;
	}
#endif
}

void deselect()
{
#ifdef USE_LUN_CONFIG
	switch (MAL_Mediano) {
	case 0:		// Select Medium_0
		if (LUN_Config & 0x04){
		// SMC
			PEDR |= 0x02;	// PE1 : SMC CE = 1
			PCDR |= 0x80;	// PC7 Output : LED1
		}
		else if (LUN_Config & 0x08){
		// SD
			PDDR |= 0x02;	// PD1 Output : LED3
		}
		else if (LUN_Config & 0x10){
		// FLASH
			PEDR |= 0x01;	// PE0 : NAND CE = 1
			PDDR |= 0x80;	// PD7 Output : LED9
		}
		else if (LUN_Config & 0x20){
		// CF
			PEDR |= 0x04;	// PE2 : CF CE = 1
			PDDR |= 0x08;	// PD3 Output : LED5
		}
		else if (LUN_Config & 0x40){
		// SONY
			PDDR |= 0x20;	// PD5 Output : LED7
		}
		break;		

	case 1:		// Select Medium_1
		if (LUN_Config & 0x08){
		// SD
			PDDR |= 0x02;	// PD1 Output : LED3
		}
		else if (LUN_Config & 0x10){
		// FLASH
			PEDR |= 0x01;	// PE0 : NAND CE = 1
			PDDR |= 0x80;	// PD7 Output : LED9
		}
		else if (LUN_Config & 0x20){
		// CF
			PEDR |= 0x04;	// PE2 : CF CE = 1
			PDDR |= 0x08;	// PD3 Output : LED5
		}
		else if (LUN_Config & 0x40){
		// SONY
			PDDR |= 0x20;	// PD5 Output : LED7
		}
		break;

	case 2:		// Select Medium_2
		if (LUN_Config & 0x10){
		// FLASH
			PEDR |= 0x01;	// PE0 : NAND CE = 1
			PDDR |= 0x80;	// PD7 Output : LED9
		}
		else if (LUN_Config & 0x20){
		// CF
			PEDR |= 0x04;	// PE2 : CF CE = 1
			PDDR |= 0x08;	// PD3 Output : LED5
		}
		else if (LUN_Config & 0x40){
		// SONY
			PDDR |= 0x20;	// PD5 Output : LED7
		}
		break;

	case 3:		// Select Medium_3
		if (LUN_Config & 0x20){
		// CF
			PEDR |= 0x04;	// PE2 : CF CE = 1
			PDDR |= 0x08;	// PD3 Output : LED5
		}
		else if (LUN_Config & 0x40){
		// SONY
			PDDR |= 0x20;	// PD5 Output : LED7
		}
		break;

	case 4:		// Select Medium_4
		// SONY
		PDDR |= 0x20;	// PD5 Output : LED7
		break;

	default:
		break;
	}
#else
	switch (MAL_Mediano) {
#ifdef USE_SMC
	case SMC_INDEX:		// Select Medium_0
		PEDR |= 0x02;	// PE1 : SMC CE = 1
		PCDR |= 0x80;	// PC7 Output : LED1
		break;
#endif

#ifdef USE_MMC
	case MMC_INDEX:		// Select Medium_1
		PDDR |= 0x02;	// PD1 Output : LED3
		break;
#endif

#ifdef USE_CF
	case CF_INDEX:		// Select Medium_0
		PEDR |= 0x04;	// PE2 : CF CE = 1
		PDDR |= 0x08;	// PD3 Output : LED5
		break;
#endif

#ifdef USE_SONY
	case SONY_INDEX:		// Select Medium_1
		PDDR |= 0x20;	// PD5 Output : LED7
		break;
#endif

#ifdef USE_FLASH
	case FLASH_INDEX:		// Select Medium_1
		PEDR |= 0x01;	// PE0 : NAND CE = 1
		PDDR |= 0x80;	// PD7 Output : LED9
		break;
#endif
	default:
		break;
	}
#endif
}

extern unsigned char MAL_Call(char Index, char iFunc);
unsigned char isWrite_Protect()
{
#ifdef USE_LUN_CONFIG
	switch (MAL_Mediano) {
	case 0:		// Select Medium_0
		if (LUN_Config & 0x04){
		// SMC
			return !ValBit(PADR,7); // Slot write protect detection
		}
		else if (LUN_Config & 0x08){
		// SD
			return ValBit(PCDR,6); // Slot write protect detection
		}
	
	case 1:
		return ValBit(PCDR,6); // Slot write protect detection		
	
	default:
		return 0;
	}
#else
	switch (MAL_Mediano) {
#ifdef USE_SMC	
	case SMC_INDEX:
		return !ValBit(PADR,7); // Slot write protect detection
#endif

#ifdef USE_MMC
	case MMC_INDEX:
		return ValBit(PCDR,6); // Slot write protect detection		
#endif

#ifdef USE_SONY
	case SONY_INDEX:
		return MAL_Call(MAL_Mediano, MAL_CHECK_WP); // Slot write protect detection
#endif

	default:
		return 0;
	}
#endif
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
// This is the main for application
void App_main()
{

	App_init();
	MAL_Init();

	while(1)						// application main loop
	{   
#ifdef	USB_POLLING_MODEL
		USB_Polling();
#endif
		if (vUSB_Configuration) {
			USER_Application();

			BOT_Action();
		}
	}
}

/**************** (c) 2000  STMicroelectronics **********************/