/**************** (c) 2000  STMicroelectronics **********************

PROJECT : USB - ST7 FULL SPEED

VERSION :  v 0.96

CREATION DATE :  01/12/2000

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#include "mcu_conf.h"
#include "usb_lib.h"
#include "appli.h"
#include "descript.h"

#pragma CONST_SEG DESC_CONST
const char Appli_DeviceDescriptor[SIZE_DEVICE_DESC] = {
	SIZE_DEVICE_DESC,	/* Size of this descriptor in bytes */
	0x01,	/* DEVICE descriptor type */
	0x10,
	0x01,	/* bcdUSB version = 1.10 */
	0x00,	/* Class is specified in the interface descriptor */
	0x00,	/* Subclass is specified in the interface descriptor */
	0x00,	/* Protocol is specified in the interface descriptor */
	MAX_PACKET_SIZE,	/* Maximum packet size for default pipe = 16 for 7265, 8 for 72SCR */
	0x83, 0x04,	/* Vendor ID */
	0x20, 0x03,	// Product ID 0x0320 for Mass Storage with DFU
//	0x33, 0x16,	// for RBC Simulator
	0x04,
	0x01,	/* bcdDevice = 1.04 */
	0x1,	/* iManufacturer */
	0x2,	/* iProduct */
	0x3,	/* iSerialNumber */
	MAX_NUM_CONFIG	/* Number of possible configuration = MAX_NUM_CONFIG */
};

const char Appli_StringDescriptor[SIZE_STRING_DESCRIPTOR] = {
	SIZE_STRING_DESCRIPTOR,
	0x03,
	0x09,
	0x04	/* LangID = 0x0409: U.S. English */
};


const char Appli_StringVendor[SIZE_STRING_VENDOR] = {
	SIZE_STRING_VENDOR,
	0x03,
/* Manufacturer: "STMicroelectronics" */
	'S',0, 'T',0, 'M',0, 'i',0, 'c',0, 'r',0, 'o',0, 'e',0,
	'l',0, 'e',0, 'c',0, 't',0, 'r',0, 'o',0, 'n',0, 'i',0,
	'c',0, 's',0
};


const char Appli_StringProduct[SIZE_STRING_PRODUCT] = {
    SIZE_STRING_PRODUCT,
	0x03,
/* Product name: */
	'S',0, 'T',0, '7',0, '2',0, 'F',0, '6',0, '5',0, ' ',0,
	'M',0, 'a',0, 's',0, 's',0, ' ',0, 'S',0, 't',0, 'o',0,
	'r',0, 'a',0, 'g',0, 'e',0, ' ',0, '5',0, ' ',0, 'i',0,
	'n',0, ' ',0, '1',0, ' ',0, 'b',0, 'o',0, 'a',0, 'r',0,
	'd',0
};

/* Serial number is the must for the BOT device */
/* There must be at least 12 digits */
/* Each digit must be 0-9 or A-F	*/
const char Appli_StringSerial[SIZE_STRING_SERIAL] = {
	SIZE_STRING_SERIAL,
	0x03,
	'0',0, '1',0, '2',0, '3',0, '4',0, '5',0, '6',0, '7',0,
	'8',0, '9',0, 'A',0, 'B',0, 'C',0, 'D',0, 'E',0, 'F',0
};

const char Appli_StringInterface[SIZE_STRING_INTERFACE] = {
	SIZE_STRING_INTERFACE,
	0x03,
#ifdef DFU_DEMO_FLASH_ONLY
	'S',0, 'M',0, 'F',0
#else
	'S',0, 'M',0, 'C',0, ' ',0, 'S',0, 'D',0, ' ',0,
	'C',0, 'F',0, ' ',0, 'S',0, 'M',0, 'F',0, ' ',0, 'M',0, 'S',0
#endif
};

const char Appli_DFU_StringInterface[SIZE_STRING_DFU_INTERFACE] = {
	SIZE_STRING_DFU_INTERFACE,
	0x03,
// Interface name: "DFU For 5 in 1 Demo"
	'D',0, 'F',0, 'U',0, ' ',0, 'F',0, 'o',0, 'r',0, ' ',0,
	'5',0, ' ',0, 'i',0, 'n',0, '1',0, ' ',0, 'D',0, 'e',0,
	'm',0, 'o',0
};

const char  Appli_ConfigDescriptor[SIZE_CONFIG_DESC] = {
/*-------------------------- Configuation Descriptor ------------------------*/
	0x09,	/* bLength: Configuation Descriptor size */
	0x02,	/* bDescriptorType: Configuration */
/*********************** wTotalLength: 25 Bytess **********************/
	SIZE_CONFIG_DESC,	/* wTotalLength: 32 Bytes returned */
	0x00,
/*********************** 2 interface **********************/        
	MAX_NUM_INTERFACE,	/* bNumInterfaces */
/***********************************************************/
	0x01,	/* bConfigurationValue: Configuration value */
	0x00,	/* iConfiguration: Index of the configuration string descriptor */
	0x80,	/* bmAttributes: bus powered */
	0x32,	/* MaxPower 100 mA */
/*------------------- Bulk Only Data Interface Descriptor -------------------*/
	0x09,	/* bLength: Interface Descriptor size */
	0x04,	/* bDescriptorType: Interface descriptor type */
	0x00,	/* bInterfaceNumber: Number of Interface */
	0x00,	/* bAlternateSetting: Alternate setting */
	0x02,	/* bNumEndpoints: Two endpoints used */
	0x08,	/* bInterfaceClass: MASS STORAGE CLASS */
	0x06,	/* bInterfaceSubClass: No subclass */
	0x50,	/* bInterfaceProtocol: Bulk Only Transport */
	0x04,	/* iInterface: Index of string descriptor */
/*------------------------ BULK IN Endpoint Descriptor ----------------------*/
	0x07,	/* bLength: Endpoint Descriptor size */
	0x05,	/* bDescriptorType: Endpoint descriptor type */
	0x82,	/* bEndpointAddress: Endpoint Address (IN) */
	0x02,	/* bmAttributes: Bulk endpoint */
	MAX_EP2_PACKET_SIZE,	/* wMaxPacketSize: Bulk endpoint maximum packet size is 64 bytes  */
	0x00,
	0x00,	/* bInterval: ignore for Bulk transfer */
/*----------------------- BULK OUT Endpoint Descriptor ----------------------*/ 
	0x07,	/* bLength: Endpoint Descriptor size */
	0x05,	/* bDescriptorType:	Endpoint descriptor type */
	0x02,	/* bEndpointAddress: Endpoint Address (OUT) */
	0x02,	/* bmAttributes: Bulk endpoint */
	MAX_EP2_PACKET_SIZE,	/* wMaxPacketSize: Bulk endpoint maximum packet size is 64 bytes  */
	0x00,
	0x00,	/* bInterval: ignore for Bulk transfer */

//------------------ DFU interface Descriptor -----------------------
	0x09,	// bLength: Interface Descriptor size
	0x04,	// bDescriptorType: Interface descriptor type
	0x01,	// bInterfaceNumber: Number of Interface
	0x00,	// bAlternateSetting: Alternate setting
	0x00,	// bNumEndpoints: Only the control pipe is used
	0xFE,	// bInterfaceClass: Application specific class code
	0x01,	// bInterfaceSubClass: Device Firmware Upgrade Code
	0x00,	// bInterfaceProtocol: The device does not use a class
			//						specific protocol on this interface
	0x05,	// iInterface: Index of string descriptor

//------------------ DFU Functional Descriptor ----------------------
	0x07,	// bLength: DFU Functional Descriptor size
	0x21,	// bDescriptorType: DFU Functional descriptor type
	0x03,	// bmAttributes: bitManifestationTolerant = 0 (No)
			//				 bitCanUpload = 1 (Yes)
			//				 bitCanDnload = 1 (Yes)
	0x20,
	0x4E,	// wDetachTimeOut: 20ms = 20000us = 0x4E20
	0x80,
	0x00	// wTransferSize: 128bytes
};

/**************** (c) 2000  STMicroelectronics **********************/





