#include "map_7265.h"
#include "usb_def.h"
#include "usb_lib.h"
#include "usb_reg.h"

#include "descript.h"
#include "appli.h"
#include "app_usb.h"
#include "user_usb.h"

#pragma CODE_SEG APPLI_CODE

void App_Set_Configuration(void)
{
	BOT_Init();
}

char App_Set_Interface(void)
{
	if (sUSB_vSetup.USBwValue != 0)
		return REQ_ERROR;
	return REQ_SUCCESS;
}

char App_Get_Interface(void)
{
	if (sUSB_vSetup.USBwValue != 0)
		RequestError();
	return 0;
}

void App_USB_Reset(void)
{
	// Prepare Application descriptor set
	DeviceDescriptor.Descriptor = Appli_DeviceDescriptor;
	DeviceDescriptor.Size = SIZE_DEVICE_DESC;

	ConfigDescriptor[0].Descriptor = Appli_ConfigDescriptor;
	ConfigDescriptor[0].Size = SIZE_CONFIG_DESC;

	StringDescriptor[0].Descriptor = Appli_StringDescriptor;
	StringDescriptor[0].Size = SIZE_STRING_DESCRIPTOR;

	StringDescriptor[1].Descriptor = Appli_StringVendor;
	StringDescriptor[1].Size = SIZE_STRING_VENDOR;
	StringDescriptor[2].Descriptor = Appli_StringProduct;
	StringDescriptor[2].Size = SIZE_STRING_PRODUCT;

	StringDescriptor[3].Descriptor = Appli_StringSerial;
	StringDescriptor[3].Size = SIZE_STRING_SERIAL;

	StringDescriptor[4].Descriptor = Appli_StringInterface;
	StringDescriptor[4].Size = SIZE_STRING_INTERFACE;

	StringDescriptor[5].Descriptor = Appli_DFU_StringInterface;
	StringDescriptor[5].Size = SIZE_STRING_DFU_INTERFACE;

	// Initialize USB library variables
	vUSB_Num_Configuration = MAX_NUM_CONFIG;
	vUSB_Num_Interface = MAX_NUM_INTERFACE;
	vUSB_Num_Strings = 5;
	vUSB_Interrupt_Mask = INT_MASK;


	CNT2RXR = 64;
}

void App_USB_SOF(void)
{
}

void App_Status_In(void)
{
	asm NOP;		// For testing
}

void App_Status_Out()
{
	asm NOP;		// For testing
}


char App_USB_Setup()
{
	extern unsigned char Max_Lun;

	if (sUSB_vSetup.USBwIndex != 0)		// It must be interface 0
		goto Req_Err;

	switch (sUSB_vSetup.USBbmRequestType) {
	case REQ_TYPE_CLASS | RECIPIENT_INTERFACE | 0x80:
		if (sUSB_vSetup.USBbRequest != 0xFE)	// GetMaxLUN for BOT devices
			break;
		if ((sUSB_vSetup.Flag & (NON0_wValue | NON0_wIndex1 | ONE_wLength)) != ONE_wLength)
			break;

		sUSB_vSetup.USBwValue0 = Max_Lun;
		vUSB_length = 1;
		vUSB_DataToCopy = &sUSB_vSetup.USBwValue0;
		return REQ_SUCCESS;

	case REQ_TYPE_CLASS | RECIPIENT_INTERFACE:
		if (sUSB_vSetup.USBbRequest != 0xFF)	// Interface Reset for BOT devices
			break;
		if (sUSB_vSetup.Flag & (NON0_wValue | NON0_wIndex1 | NON0_wLength))
			break;
		if (sUSB_vSetup.USBwIndex0 >= Max_Lun)
			break;
		BOT_Reset();
		return REQ_SUCCESS;

	default:
		break;
	}

Req_Err:
	RequestError();
	return REQ_ERROR;
}

void App_Set_Feature_Int(void)
{
	RequestError();		// Inappropriate Request. Recipient does not exist.
}

void App_Clear_Feature_Int(void)
{
	RequestError();		// Inappropriate Request. Recipient does not exist.
}

void App_Set_Feature_EP(void)
{
}

void App_Clear_Feature_EP(void)
{
	extern void BOT_Clear_Feature_EP(void);	// See BOT.c
	BOT_Clear_Feature_EP();
}

void App_CopydataIN(unsigned char Length)
{           
}

void App_CopydataOUT(unsigned char Length)
{
}
