/**************** (c) 2000  STMicroelectronics *******************************

NAME:		usb_app.h
PROJECT:	USB - ST7 FULL SPEED
VERSION:	v 1.0
CREATION:	04/01/2002
AUTHOR:		MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	This header file defines all functions that user application provides
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/
#include "usb_lib.h"

#ifndef DEFINE_APP_USB
#define DEFINE_APP_USB

// Virtual declaration of the application function vectors
void Vec_main(void);
void VEC_Trap(void);
void VEC_Plug(void);	// Power Management USB Plug/Unplug
void VEC_EI0(void);		// External Interrupt Port A
void VEC_DTC(void);		// DTC Peripheral Interrupt
void VEC_EI1(void);		// External Interrupt Port D
void VEC_I2C(void);		// I2C Interrupt
void VEC_Timer(void);	// Timer interrupt

void Vec_USB_Setup(void);	// Process of SETUP packet
void Vec_CopydataIN(unsigned char Length);
void Vec_CopydataOUT(unsigned char Length);
char Vec_Set_Configuration(void);
char Vec_Set_Interface(void);
char Vec_Get_Interface(void);

void Vec_Status_In(void);
void Vec_Status_Out(void);

void Vec_Set_Feature_Int(void);
void Vec_Set_Feature_EP(void);
void Vec_Clear_Feature_Int(void);
void Vec_Clear_Feature_EP(void);

void Vec_USB_Reset(void);
void Vec_USB_Suspend(void);
void Vec_USB_ESuspend(void);
void Vec_USB_SOF(void);

#endif	// DEFINE_APP_USB
