#ifndef DEFINE_DFU_H
#define DEFINE_DFU_H

#define DFU_TRANSFERSIZE	128

// Variables export from DFU.c
extern unsigned char DFU_Buffer[128];

typedef struct dfu_status {
	unsigned char bStatus;
	unsigned char bwPollTimeout[3];
	unsigned char bState;
	unsigned char iString;
} DFU_STATUS;

#pragma DATA_SEG DFU_RAM
extern unsigned char DFU_State;

#pragma DATA_SEG SHORT DFU_RAM0
extern unsigned char DFU_Request;
extern unsigned char DFU_Action;
extern unsigned char DFU_BlockSiz;
extern unsigned int DFU_BlockNum;
extern unsigned int DFU_Timeout;
extern DFU_STATUS DFU_Status;

// Functions export from DFU.c
unsigned char DFU_App_Valid();
unsigned char DFU_Setup();
void DFU_CopyDataIN(unsigned char Length);
void DFU_CopyDataOUT(unsigned char Length);
void DFU_Status_In(void);
void DFU_Status_Out(void);

// States of DFU machine
#define STATE_appIDLE				0
#define STATE_appDETACH				1
#define STATE_dfuIDLE				2
#define STATE_dfuDNLOADSYNC			3
#define STATE_dfuDNBUSY				4
#define STATE_dfuDNLOADIDLE			5
#define STATE_dfuMANIFESTSYNC		6
#define STATE_dfuMANIFEST			7
#define STATE_dfuMANIFESTWAITRESET	8
#define STATE_dfuUPLOADIDLE			9
#define STATE_dfuERROR				10

//------------------------------------
// DFU Class-Specific Request Values
// Table 3.2 Page 9 of DFU spec rev1.0
//------------------------------------
#define DFU_DETACH		0
#define DFU_DNLOAD		1
#define DFU_UPLOAD		2
#define DFU_GETSTATUS	3
#define DFU_CLRSTATUS	4
#define DFU_GETSTATE	5
#define DFU_ABORT		6
#define DFU_REQUEST		0xF0

//-----------------------------------
// DFU Device Status
// Page 19 of in DFU spec rev1.0
// Used by variable : DFUDeviceStatus
//-----------------------------------
#define DFU_STATUS_OK				0x00
#define DFU_STATUS_ERRTARGET		0x01
#define DFU_STATUS_ERRFILE			0x02
#define DFU_STATUS_ERRWRITE			0x03
#define DFU_STATUS_ERRERASE			0x04
#define DFU_STATUS_ERRCHECK_ERASED	0x05
#define DFU_STATUS_ERRPROG			0x06
#define DFU_STATUS_ERRVERIFY		0x07
#define DFU_STATUS_ERRADDRESS		0x08
#define DFU_STATUS_ERRNOTDONE		0x09
#define DFU_STATUS_ERRFIRMWARE		0x0A
#define DFU_STATUS_ERRVENDOR		0x0B
#define DFU_STATUS_ERRUSBR			0x0C
#define DFU_STATUS_ERRPOR			0x0D
#define DFU_STATUS_ERRUNKNOWN		0x0E
#define DFU_STATUS_ERRSTALLEDPKT	0x0F

// DFU_Actions
#define DFU_LAST		0x10
#define DFU_UPLOADLAST	(DFU_UPLOAD | DFU_LAST)
#define DFU_DNLOADLAST	(DFU_DNLOAD | DFU_LAST)
#define DFU_DNLOADBUSY	(DFU_DNLOAD | 0x20)
#define DFU_DNLOADSYNC	(DFU_DNLOAD | 0x40)
#define DFU_DNLOADIDLE	(DFU_DNLOAD | 0x80)
#define DFU_ERRORACTION	(7 | DFU_LAST)
#define DFU_MANIFESTSYNC (8 | DFU_LAST)

// DFU_Capability
#define CAP_bitManifestationTolerant	0x01
#define CAP_bitCanUpload				0x02
#define CAP_bitCanDnload				0x04

// Declaration of DFU descriptor set
#define SIZE_DFU_CONFIG_DESC			25

#define SIZE_DFU_STRING_DESCRIPTOR		4
#define SIZE_DFU_STRING_VENDOR			38
#define SIZE_DFU_STRING_PRODUCT			34
#define SIZE_DFU_STRING_INTERFACE		50

#define NUM_DFU_STRING_DESC				5

#pragma CONST_SEG DFU_CONST
extern const char DFU_DeviceDescriptor[];
extern const char DFU_ConfigDescriptor[];
extern const char DFU_StringDescriptor[];
extern const char DFU_StringVendor[];
extern const char DFU_StringProduct[];
extern const char DFU_StringInterface[];


#endif // DEFINE_DFU_H