#include "mcu_conf.h"
#include "DFU.h"

#pragma CONST_SEG DFU_CONST
const char DFU_DeviceDescriptor[18] = {
	18,		// Size of this descriptor in bytes
	0x01,	// DEVICE descriptor type
	0x10,
	0x01,	// bcdUSB version = 1.10
	0xFE,	// DFU: Application Specific Class Code
	0x01,	// Device Firmware Upgrade Code
	0x00,	// The device does not use a class specific protocol on this interface.
	MAX_PACKET_SIZE,	// Maximum packet size for default pipe = 16 for 7265
	0x83, 0x04,	// Vendor ID
	0x11, 0xDF,	// Product ID 0xDF11 for DFU
	0x20,
	0x01,	// bcdDevice = 1.20
	0x1,	// iManufacturer
	0x2,	// iProduct
	0x0,	// iSerialNumber
	1		// One configuration only for DFU
};

const char DFU_StringDescriptor[SIZE_DFU_STRING_DESCRIPTOR] = {
	SIZE_DFU_STRING_DESCRIPTOR,
	0x03,
	0x09,
	0x04	// LangID = 0x0409: U.S. English
};

const char DFU_StringVendor[SIZE_DFU_STRING_VENDOR] = {
	SIZE_DFU_STRING_VENDOR,
	0x03,
// Manufacturer: "STMicroelectronics"
	'S',0, 'T',0, 'M',0, 'i',0, 'c',0, 'r',0, 'o',0, 'e',0,
	'l',0, 'e',0, 'c',0, 't',0, 'r',0, 'o',0, 'n',0, 'i',0,
	'c',0, 's',0
};

const char DFU_StringProduct[SIZE_DFU_STRING_PRODUCT] = {
    SIZE_DFU_STRING_PRODUCT,
	0x03,
// Product name: "ST72F65 DFU Demo"
	'S',0, 'T',0, '7',0, '2',0, 'F',0, '6',0, '5',0, ' ',0,
	'D',0, 'F',0, 'U',0, ' ',0, 'D',0, 'e',0, 'm',0, 'o',0
};

const char DFU_StringInterface[SIZE_DFU_STRING_INTERFACE] = {
	SIZE_DFU_STRING_INTERFACE,
	0x03,
// Interface name: "Device Firmware Upgrage"
	'D',0, 'e',0, 'v',0, 'i',0, 'c',0, 'e',0, ' ',0, 'F',0,
	'i',0, 'r',0, 'm',0, 'w',0, 'a',0, 'r',0, 'e',0, ' ',0,
	'U',0, 'p',0, 'g',0, 'r',0, 'a',0, 'd',0, 'e',0, ' ',0
};


const char  DFU_ConfigDescriptor[SIZE_DFU_CONFIG_DESC] = {
//------------------ Configuation Descriptor ------------------------
	0x09,	// bLength: Configuation Descriptor size
	0x02,	// bDescriptorType: Configuration
//*********************** wTotalLength: 25 Bytess **********************
	SIZE_DFU_CONFIG_DESC,	// wTotalLength: 32 Bytes returned
	0x00,
//*********************** 1 interface **********************
	0x01,	// bNumInterfaces
/***********************************************************/
	0x01,	// bConfigurationValue: Configuration value
	0x00,	// iConfiguration: Index of the configuration string descriptor
	0x80,	// bmAttributes: bus powered
	0x32,	// MaxPower 100 mA

//------------------ DFU interface Descriptor -----------------------
	0x09,	// bLength: Interface Descriptor size
	0x04,	// bDescriptorType: Interface descriptor type
	0x00,	// bInterfaceNumber: Number of Interface
	0x00,	// bAlternateSetting: Alternate setting
	0x00,	// bNumEndpoints: Only the control pipe is used
	0xFE,	// bInterfaceClass: Application specific class code
	0x01,	// bInterfaceSubClass: Device Firmware Upgrade Code
	0x00,	// bInterfaceProtocol: The device does not use a class
			//						specific protocol on this interface
	0x03,	// iInterface: Index of string descriptor

//------------------ DFU Functional Descriptor ----------------------
	0x07,	// bLength: DFU Functional Descriptor size
	0x21,	// bDescriptorType: DFU Functional descriptor type
	0x06,	// bmAttributes: bitManifestationTolerant = 0 (No)
			//				 bitCanUpload = 1 (Yes)
			//				 bitCanDnload = 1 (Yes)
	0x20,
	0x4E,	// wDetachTimeOut: 20ms = 20000us = 0x4E20
	DFU_TRANSFERSIZE,
	0x00	// wTransferSize: 128
};
