/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : HDFlash Driver
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.0
#
# DESCRIPTION : Drivers to program and erase HDFlash memory. 
#
# HISTORY :
# 22-JUL-2002 V0.1 Creation
# 25-JUL-2002 V0.2 All functions are created
# 01-AUG-2002 V1.0 Macros created
#								                                                              
******************************************************************************/

#ifndef HDFLASH_H
#define HDFLASH_H

#define FCPU 8

// Embedded Command Parameters
#define EMBLG_PARAM_FREQ (*(unsigned char *)0xF8)
#define EMBLG_PARAM_DATA (*(unsigned char *)0xF9)
#define EMBLG_PARAM_ENDH (*(unsigned char *)0xFA)
#define EMBLG_PARAM_ENDL (*(unsigned char *)0xFB)
#define EMBLG_PARAM_END (*(unsigned char **)0xFA)
#define EMBLG_PARAM_PTRH (*(unsigned char *)0xFC)
#define EMBLG_PARAM_PTRL (*(unsigned char *)0xFD)
#define EMBLG_PARAM_PTR (*(unsigned short *)0xFC)
#define EMBLG_PARAM_SECT (*(unsigned char *)0xFE)
#define EMBLG_PARAM_ECMD (*(unsigned char *)0xFF)

// Embedded Command Return Status Codes
#define HDFLASH_BYTEPROG_OK   0x00
#define HDFLASH_BLOCKPROG_OK  0x01
#define HDFLASH_OPTIONPROG_OK 0x02
#define HDFLASH_ERASE_OK      0x03
#define HDFLASH_PROGALL_OK    0x04
#define HDFLASH_OPTIONREAD_OK 0x05
#define HDFLASH_CHECKSUM_OK   0x06

// Miscellanous
#define HDFLASH_BUSY 0x80

// Functions Prototypes
#define Flash_Status EMBLG_PARAM_ECMD	// align with the status

#define Command_Number(num) EMBLG_PARAM_ECMD = (num)
#define Sector_Number(sect) EMBLG_PARAM_SECT = (sect)
#define Set_Frequency(freq) EMBLG_PARAM_FREQ = (freq)
#define Program_Byte(data)	EMBLG_PARAM_DATA = (data)
#define Program_Address(adr) EMBLG_PARAM_PTR = (adr)
#define Data_Buffer(buf)	EMBLG_PARAM_END = (buf)
#define Start_Flashing()	FCSR = 0x00
#define FLASH_BUSY			(EMBLG_PARAM_ECMD & HDFLASH_BUSY)

//extern void RASS_Disable(unsigned char, unsigned char);
#define RASS_Disable(key1, key2) {	\
	FCSR = key1;	/* First hardware key */ \
	FCSR = key2;	/* Second hardware key */ }


//unsigned char extern HDFlashEraseSector(unsigned char, unsigned char);
#define HDFlashEraseSector(Sector, Freq) {	\
	EMBLG_PARAM_PTRH = Sector_Number(Sector);	\
	EMBLG_PARAM_PTRL = Command_Number(0x03);	\
	Set_Frequency(Freq);						\
	do Start_Flashing(); while (FLASH_BUSY); }

//unsigned char extern HDFlashWriteByte(unsigned char, unsigned int, unsigned char);
#define HDFlashWriteByte(Data, Address, Freq) { \
	Program_Address(Address);	\
	Program_Byte(Data);			\
	Command_Number(0x00);	\
	Set_Frequency(Freq);	\
	Start_Flashing();	}

//unsigned char extern HDFlashWriteBlock(unsigned char *, unsigned char *, unsigned char, unsigned char);
#define HDFlashWriteBlock(Buffer, Address, ByteNb, Freq) {	\
	Program_Address(Address);	\
	Sector_Number(ByteNb);	\
	Command_Number(0x01);	\
	Data_Buffer(Buffer);	\
	Set_Frequency(Freq);	\
	do Start_Flashing(); while (FLASH_BUSY); }

#endif

/*** END OF FILE ***/