/**************** (c) 2000  STMicroelectronics **********************

PROJECT : ST7265 5in1 Demo with DFU feature

VERSION :  v 1.0

CREATION DATE :  16/07/2002

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/


#include "mcu_conf.h"
#include "usb_def.h"
#include "usb_reg.h"
#include "usb_Lib.h"

#include "descript.h"
#include "user_usb.h"
#include "appli.h"
#include "MConfig.h"

#include "app_usb.h"
#include "DFU.h"

#pragma DATA_SEG USER_USB_RAM
ONE_DESCRIPTOR DeviceDescriptor;
ONE_DESCRIPTOR ConfigDescriptor[1];
ONE_DESCRIPTOR StringDescriptor[6]; // Vendor, product, serial, interface1, interface0
unsigned int Reset_point;

#pragma CODE_SEG USER_USB_CODE

unsigned int Set_Label()
{
	asm {
		LD		Y, S
		LD		A, (0x101, Y)
		LD		X, A
		LD		A, (0x102, Y)
	}
}

#pragma NO_ENTRY
void Jmp_Label(unsigned int pc)
{
	asm {
		RSP
		LD		_LEX, X
		LD		_LEX:1, A
		JP		[_LEX.w]
	}
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USER_USB_Set_Configuration
INPUT/OUTPUT : None
DESCRIPTION  : Assign configuration value sent by Host & reset Stalled EPs.
-----------------------------------------------------------------------------*/
char USER_USB_Set_Configuration(void)
{
	// Valid request in ADDRESS_STATE and CONFIGURED_STATE
	if (vUSB_Configuration == 0) {	// Device is Unconfigured
		USB_SetTxEP2Status(EP_DISABLE);
		USB_SetRxEP2Status(EP_DISABLE);
	}
	else {	// Device is now configured, you can start your USB Application
		if (DFU_State == STATE_appIDLE)
			Vec_Set_Configuration();
	}

	return REQ_SUCCESS;	// If the configuration is not one of the expected, you can answer an ERROR
				// The Library check that vUSB_Configuration is not higher than MAX_NUM_CONFIG
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USER_USB_Set_Interface
INPUT/OUTPUT : None
DESCRIPTION  : Change Interface Value 
-----------------------------------------------------------------------------*/
char USER_USB_Set_Interface(void)
{
	if (DFU_State == STATE_appIDLE) {
		if (sUSB_vSetup.USBwIndex >= vUSB_Num_Interface)	// out of range
			return REQ_ERROR;

		if (sUSB_vSetup.USBwIndex < (vUSB_Num_Interface-1)) {
			// DFU interface is the last interface
			// Process with non DFU interface
			Vec_Set_Interface();
			return;
		}
	}
	else {
		// There are 1 interface in DFU mode
		if (sUSB_vSetup.USBwIndex > 0)
			return REQ_ERROR;
	}

	// The alternate setting of DFU interface should be 0
	if (sUSB_vSetup.USBwValue != 0)
		return REQ_ERROR;
	return REQ_SUCCESS;
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USER_USB_Get_Interface
INPUT/OUTPUT : None
DESCRIPTION  : Change Alternative Interface Setting
-----------------------------------------------------------------------------*/
char USER_USB_Get_Interface(void)		// return the alternate setting number.
{
	// The interface number should be less than 1
	if (DFU_State == STATE_appIDLE) {
		if (sUSB_vSetup.USBwIndex >= vUSB_Num_Interface)	// out of range
			RequestError();

		if (sUSB_vSetup.USBwIndex == (vUSB_Num_Interface-1))
			return 0;			// alternate setting for DFU interface is 0

		Vec_Get_Interface();
		return;
	}
	else {
		// There are 1 interface in DFU mode
		if (sUSB_vSetup.USBwIndex > 0)
			RequestError();
	}
	return 0;
}

void USER_USB_Reset() 
{
	extern unsigned int DFU_Timeout;
	if ((DFU_State == STATE_appDETACH) && DFU_Timeout) {
//		Replug_Device();
		Jmp_Label(Reset_point);
	}
//	if (DFU_State == STATE_dfuMANIFESTWAITRESET) {
//		Replug_Device();
//		Jmp_Label(Reset_point);
//	}
	if (DFU_State == STATE_dfuIDLE ) {
		// This is not DFU compliance.
		// Because MS-Windows sends many reset, we have to do this
		Jmp_Label(Reset_point);
	}

	if (DFU_App_Valid()) {
		Vec_USB_Reset();
		USBIMR = vUSB_Interrupt_Mask;

		DFU_State = STATE_appIDLE;
	}
	Jmp_Label(Reset_point);
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_Status_In
INPUT/OUTPUT : None
DESCRIPTION  : Application post process after status IN stage
	(if a request need to be executed after a Status_In, for example SET_ADDRESS)
-----------------------------------------------------------------------------*/
void USER_USB_Status_In(void)
{
	if (DFU_State == STATE_appIDLE)
		Vec_Status_In();
	else
		DFU_Status_In();
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USB_Status_Out
INPUT/OUTPUT : None
DESCRIPTION  : Application post process after status OUT stage 
-----------------------------------------------------------------------------*/
void USER_USB_Status_Out()
{
	if (DFU_State == STATE_appIDLE)
		Vec_Status_Out();
	else
		DFU_Status_Out();
}

void USER_USB_SOF()
{
	if (DFU_State == STATE_appIDLE)
		Vec_USB_SOF();
}

void USER_USB_Suspend()
{
	if (DFU_State == STATE_appIDLE) {
		Vec_USB_Suspend();
		asm HALT;
	}
}

void USER_USB_ESuspend(){
	if (DFU_State == STATE_appIDLE)
		Vec_USB_ESuspend();
}

void USER_USB_WakeUp()
{
	asm NOP;
}

char USER_USB_Setup()
{
	if (sUSB_vSetup.USBwIndex >= vUSB_Num_Interface) {		// Out of range
		RequestError();
		return REQ_ERROR;
	}

	if (DFU_State == STATE_appIDLE) {
		if (sUSB_vSetup.USBwIndex < (vUSB_Num_Interface-1)) {
			// Non DFU requests
			Vec_USB_Setup();
			return;
		}
	}

	return DFU_Setup();
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USER_USB_Set_Feature_Int
INPUT/OUTPUT : None
DESCRIPTION  : Set or enable a specific feature for the specified interface.
-----------------------------------------------------------------------------*/
void USER_USB_Set_Feature_Int(void)
{
	if (DFU_State == STATE_appIDLE)
		Vec_Set_Feature_Int();
	else
		RequestError();		// Inappropriate Request. Recipient does not exist.
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USER_USB_Clear_Feature_Int
INPUT/OUTPUT : None
DESCRIPTION  : Clear or disable a specific feature for the specified interface.
-----------------------------------------------------------------------------*/
void USER_USB_Clear_Feature_Int(void)
{
	if (DFU_State == STATE_appIDLE)
		Vec_Clear_Feature_Int();
	else
		RequestError();		// Inappropriate Request. Recipient does not exist.
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USER_USB_Set_Feature_EP
INPUT/OUTPUT : None
DESCRIPTION  : Set or enable a specific feature for the specified endpoint.
-----------------------------------------------------------------------------*/
void USER_USB_Set_Feature_EP(void)
{
	if (DFU_State == STATE_appIDLE)
		Vec_Set_Feature_EP();
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : USER_USB_Clear_Feature_EP
INPUT/OUTPUT : None
DESCRIPTION  : Clear or disable a specific feature for the specified endpoint.
-----------------------------------------------------------------------------*/
void USER_USB_Clear_Feature_EP(void)
{
	if (DFU_State == STATE_appIDLE)
		Vec_Clear_Feature_EP();
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : USER_USB_Copydata
INPUT/OUTPUT : Length is number of bytes to be copied. vUSB_offset is the offset
				of your data buffer
DESCRIPTION  : 
-----------------------------------------------------------------------------*/
#pragma NO_ENTRY
void USER_USB_CopydataIN(unsigned char Length)
{
	asm PUSH	A;			// Save the parameter "Length"
	if (DFU_State == STATE_appIDLE) {
		asm POP		A;		// Restore the parameter "Length"
		asm CALL	Vec_CopydataIN;
	}
	else {
	//	DFU_CopyDataIN(Length);
		asm	POP		A;
		asm CALL	DFU_CopyDataIN
	}
}

#pragma NO_ENTRY
void USER_USB_CopydataOUT(unsigned char Length)
{
	asm PUSH	A;			// Save the parameter "Length"
	if (DFU_State == STATE_appIDLE) {
		asm POP		A;		// Restore the parameter "Length"
		asm CALL	Vec_CopydataOUT;
	}
	else {
	//	DFU_CopyDataOUT(Length);
		asm	POP		A;
		asm CALL	DFU_CopyDataOUT
	}
}

/**************** (c) 2000  STMicroelectronics **********************/