#***(c) STMicroelectronics ****************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Make file for the ST7263B 16K
#
# HISTORY :
#								                                                              
#******************************************************************************

#*** PRODUCT AND SIZE DEFINITION ***

# Here declare your product name and size 
PRODUCT = 7263B
SIZE    = 16K

#*** PATHS DEFINITION ***

# Here you declare the different tools location
TOOLS_PATH = C:\Metrowerks\Prog

#*** I/O FILES DEFINITION ***

ENV_FILE = Default.env
PRM_FILE = ST$(PRODUCT)_$(SIZE).prm
BURN_FILE = Burner.cmd
ABS_FILE = Sector0.abs

#*** COMMANDS DEFINITION ***

COMP = $(TOOLS_PATH)\Cst7.exe
LINK = $(TOOLS_PATH)\Linker.exe
BURN = $(TOOLS_PATH)\Burner.exe
ASM  = $(TOOLS_PATH)\Ast7.exe

#*** COMPILER OPTIONS ***

# Basic
#COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst
# Highest density code
COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst -Os -Ou -Of -Ol0 -OnPMNC -Or
# Lowest debug complexity
#COMPOPTIONS = -N -Cc -Ml -F7 -Lm -Lasm=%n.lst -Os -Onu -Onf -Ol0 -Onbt -Onca -Oncn -One -Ont=
# No Optimization
#COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst -Ont -Onu

#*** ASSEMBLER OPTIONS ***

ASMOPTIONS = -Ml -l

#*** COMMANDS ***

CC = $(COMP) $(COMPOPTIONS) -DMAP_FILE="Map_$(PRODUCT).h" -DST$(PRODUCT) -DHIWARE
AS = $(ASM) $(ASMOPTIONS)

#*** OBJECTS FILES DEFINITION ***

OBJ_LIST = Map_$(PRODUCT).o Descript.o \
           DFUCore.o DFUDescript.o DFUJumpTableS0_$(PRODUCT)_Hiware.o DFUProtocol.o \
           USB.o USB_Lib.o USB_Rc.o USB_Var.o USB_JumpTable_Hiware.o
	    
#*** LINKING ***

$(ABS_FILE) :	$(ENV_FILE) $(OBJ_LIST) $(PRM_FILE)
		$(LINK) $(PRM_FILE)

#*** BURNING ***

		$(BURN) -f $(BURN_FILE)

#*** COMPILATION ***

# ----------------
# MICRO DIRECTORY
# ----------------
                               
Map_$(PRODUCT).o :	$(ENV_FILE) Map_$(PRODUCT).c 
		$(CC) Map_$(PRODUCT).c

# ----------------
# APPLI DIRECTORY
# ----------------
		
Descript.o :	$(ENV_FILE) Descript.c Descript.h
		$(CC) Descript.c

# --------------
# USB DIRECTORY
# --------------

USB.o :			$(ENV_FILE) USB.c 
		$(CC) USB.c
				
USB_Lib.o :		$(ENV_FILE) USB_Lib.c 
		$(CC) USB_Lib.c  

USB_Rc.o :		$(ENV_FILE) USB_Rc.c 
		$(CC) USB_Rc.c  

USB_Var.o :		$(ENV_FILE) USB_Var.c 
		$(CC) USB_Var.c

USB_JumpTable_Hiware.o :	$(ENV_FILE) USB_JumpTable_Hiware.asm
		$(AS) USB_JumpTable_Hiware.asm

# -------------
# DFU DIRECTORY
# -------------

DFUCore.o :	$(ENV_FILE) DFUCore.c 
		$(CC) DFUCore.c

DFUDescript.o :	$(ENV_FILE) DFUDescript.c DFUDescript.h
		$(CC) DFUDescript.c

DFUJumpTableS0_$(PRODUCT)_Hiware.o :	$(ENV_FILE) DFUJumpTableS0_$(PRODUCT)_Hiware.asm
		$(AS) DFUJumpTableS0_$(PRODUCT)_Hiware.asm

DFUProtocol.o :	$(ENV_FILE) DFUProtocol.c 
		$(CC) DFUProtocol.c
		
#*** END OF FILE ***