/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Device Firmware Upgrade enable header file
#
# HISTORY :
#								                                                              
******************************************************************************/
   
#ifndef DFUCORE_H
#define DFUCORE_H

#include "Lib_Bits.h"

//------------------------------------
// DFU Class-Specific Request Values
// Table 3.2 Page 9 of DFU spec rev1.0           
//------------------------------------
#define DFU_DETACH    0
#define DFU_DNLOAD    1
#define DFU_UPLOAD    2
#define DFU_GETSTATUS 3
#define DFU_CLRSTATUS 4
#define DFU_GETSTATE  5
#define DFU_ABORT     6

//-----------------------------------
// DFU Device Status
// Page 19 of in DFU spec rev1.0
// Used by variable : DFUDeviceStatus
//-----------------------------------
#define DFU_STATUS_OK              0x00
#define DFU_STATUS_ERRTARGET       0x01
#define DFU_STATUS_ERRFILE         0x02
#define DFU_STATUS_ERRWRITE        0x03
#define DFU_STATUS_ERRERASE        0x04
#define DFU_STATUS_ERRCHECK_ERASED 0x05
#define DFU_STATUS_ERRPROG         0x06
#define DFU_STATUS_ERRVERIFY       0x07
#define DFU_STATUS_ERRADDRESS      0x08
#define DFU_STATUS_ERRNOTDONE      0x09
#define DFU_STATUS_ERRFIRMWARE     0x0A
#define DFU_STATUS_ERRVENDOR       0x0B
#define DFU_STATUS_ERRUSBR         0x0C
#define DFU_STATUS_ERRPOR          0x0D
#define DFU_STATUS_ERRUNKNOWN      0x0E
#define DFU_STATUS_ERRSTALLEDPKT   0x0F

//----------------------------------
// DFU Device State
// Page 20 of in DFU spec rev1.0
// Used by variable : DFUDeviceState
//----------------------------------
#define DFU_STATE_APPIDLE               0
#define DFU_STATE_APPDETACH             1
#define DFU_STATE_DFUIDLE               2
#define DFU_STATE_DFUDNLOADSYNC         3
#define DFU_STATE_DFUDNBUSY             4
#define DFU_STATE_DFUDNLOADIDLE         5
#define DFU_STATE_DFUMANIFESTSYNC       6
#define DFU_STATE_DFUMANIFEST           7
#define DFU_STATE_DFUMANIFESTWAITRESET  8
#define DFU_STATE_DFUUPLOADIDLE         9
#define DFU_STATE_DFUERROR             10

//---------------------
// Variables Prototypes
//---------------------
extern Byte DFUDeviceState;
extern Byte DFUDeviceStatus;
extern Byte DFUDataReceived[8];
extern Byte DFUDataToSend[8];
extern Byte DFUPollTimeOutH;
extern Byte DFUPollTimeOutL;

//---------------------
// Functions Prototypes
//---------------------

#ifdef HIWARE
#pragma CODE_SEG DFU_CORE
#endif

extern void DFU_Process(void);
extern void DFU_Init(void);
extern void DFU_HandleRequests(void);
extern void DFU_Detach(void);
extern void DFU_Download(void);
extern void DFU_Upload(void);
extern void DFU_GetStatus(void);
extern void DFU_ClearStatus(void);
extern void DFU_GetState(void);
extern void DFU_Abort(void);

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

#endif // DFUCORE_H

/*** END OF FILE ***/