/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : 
#
# HISTORY :
#								                                                              
******************************************************************************/

#ifndef DFULIBFUNCADD_H
#define DFULIBFUNCADD_H

#include "USB_Opts.h"
#include "Lib_Bits.h"

#ifdef USE_DEVICE_FIRMWARE_UPGRADE

//====================================================================
// Library functions placed in Sector 0 and called by the Application.
//====================================================================

#define Init_USB_HW           ((void(*)(void)) 0xF000)
#define Disable_USB_HW        ((void(*)(void)) 0xF003)
#define Handle_USB_Events     ((void(*)(void)) 0xF006)
#define Enable_STATUS_Stage   ((void(*)(void)) 0xF009)
#define Test_EP_Ready_NP      ((Bool(*)(void)) 0xF00C)
#define Set_EP_Ready_NP       ((void(*)(void)) 0xF00F)
#define Write_EP_Buffer_NP    ((void(*)(void)) 0xF012)
#define Read_EP_Buffer_NP     ((void(*)(void)) 0xF015)
#define DisableAppli          ((void(*)(void)) 0xF018)

#define Test_EP_Ready(EndPointPrm,DirectionPrm) (\
                                GParams.SEPRParams.EndPoint=EndPointPrm,\
                                GParams.SEPRParams.Direction=DirectionPrm,\
                                Test_EP_Ready_NP()\
                    )

#define Set_EP_Ready(EndPointPrm,DirectionPrm,LengthPrm) {\
                                GParams.SEPRParams.EndPoint=EndPointPrm;\
                                GParams.SEPRParams.Direction=DirectionPrm;\
                                GParams.SEPRParams.Length=LengthPrm;\
                                Set_EP_Ready_NP();\
                    }

#define Write_EP_Buffer(EndPointPrm,BufferPrm,LengthPrm) {\
                                GParams.WEPBParams.EndPoint=EndPointPrm;\
                                GParams.WEPBParams.Buffer=BufferPrm;\
                                GParams.WEPBParams.Length=LengthPrm;\
                                Write_EP_Buffer_NP();\
                    }

#define Read_EP_Buffer(EndPointPrm,BufferPrm) {\
                                GParams.REPBParams.EndPoint=EndPointPrm;\
                                GParams.REPBParams.Buffer=BufferPrm;\
                                Read_EP_Buffer_NP();\
                    }

#endif // USE_DEVICE_FIRMWARE_UPGRADE

#endif // DFULIBFUNCADD_H

/*** END OF FILE ***/