/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Device Firmware Upgrade protocol header file
#
# HISTORY :
#								                                                              
******************************************************************************/
   
#ifndef DFUPROTOCOL_H
#define DFUPROTOCOL_H

#include "Lib_Bits.h"

//-------------------------------------
// Constants used by variable DFUAction
//-------------------------------------
#define DFU_ACTION_NONE      0x00
#define DFU_ACTION_ERASE_S1  0x01
#define DFU_ACTION_ERASE_S2  0x02
#define DFU_ACTION_PROGRAM   0x04
#define DFU_ACTION_START     0x08

//-------------------------
// Reserved BlockNum Values
//------------------------- 
#define DFU_BLKNUM_ERASE_ALL 0xFFFF
#define DFU_BLKNUM_ERASE_S1  0xFFFE
#define DFU_BLKNUM_ERASE_S2  0xFFFD
#define DFU_BLKNUM_ADDMIN    0x1800
#define DFU_BLKNUM_ADDMAX    0x1DFF
                      
//----------------
// Other constants
//----------------
#define DFU_S1S2_ADDR 0xEFFF
#define DFU_S1S2_PASS 0x6D

//#define ENABLE_LEDS

#ifdef ENABLE_LEDS
#define LED1_OFF {PADR |= 0x40;}
#define LED1_ON  {PADR &= ~0x40;}
#define LED2_OFF {PADR |= 0x80;}
#define LED2_ON  {PADR &= ~0x80;}
#define LED3_OFF {PBDR |= 0x40;}
#define LED3_ON  {PBDR &= ~0x40;}
#define LED4_OFF {PBDR |= 0x80;}
#define LED4_ON  {PBDR &= ~0x80;}
#else
#define LED1_OFF
#define LED1_ON
#define LED2_OFF
#define LED2_ON
#define LED3_OFF
#define LED3_ON
#define LED4_OFF
#define LED4_ON
#endif

#ifdef ST7262
#define FCPU 8
#endif
#ifdef ST7263B
#define FCPU 4
#endif

//---------------------
// Variables Prototypes
//---------------------
extern Byte DFUAction;
extern Byte DFUVpp12V;
extern Byte *DFUpFlash;

//---------------------
// Functions Prototypes
//---------------------

#ifdef HIWARE
#pragma CODE_SEG DFU_PRTCL
#endif

extern Byte DFU_S1S2Valid(void);
extern void DFU_Init_User(void);
extern void DFU_Abort_User(void);
extern void DFU_ClearStatus_User(void);
extern void DFU_ManifestWaitReset_User(void);
extern void DFU_UpLoad_User(void);
extern void DFU_Download_User(void);

#ifdef SELF_POWERED
extern void VbusCheck(void);
#endif

extern void HDFlashProcess(void);
extern void SetVpp12V(void);
extern void SetVpp5V(void);

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

#endif // DFUPROTOCOL_H

/*** END OF FILE ***/