/*** (c) STMicroelectronics ***************************************************
#
# COMPILER : COSMIC / HIWARE
#
# DESCRIPTION : Register mapping for ST7262
#
******************************************************************************/

#ifdef HIWARE
#include "Map_7262.h"
#endif

/* PORTA REGISTERS */

#ifdef COSMIC
volatile unsigned char PADR @0x00;
volatile unsigned char PADDR @0x01;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTA
volatile unsigned char PADR;
volatile unsigned char PADDR;
#endif

/* PORTB REGISTERS */

#ifdef COSMIC
volatile unsigned char PBDR @0x02;
volatile unsigned char PBDDR @0x03;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTB
volatile unsigned char PBDR;
volatile unsigned char PBDDR;
#endif

/* PORTC REGISTERS */

#ifdef COSMIC
volatile unsigned char PCDR @0x04;
volatile unsigned char PCDDR @0x05;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTC
volatile unsigned char PCDR;
volatile unsigned char PCDDR;
#endif

/* PORTD REGISTERS */

#ifdef COSMIC
volatile unsigned char PDDR @0x06;
volatile unsigned char PDDDR @0x07;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTD
volatile unsigned char PDDR;
volatile unsigned char PDDDR;
#endif

/* INTERRUPT 1 REGISTER */

#ifdef COSMIC
volatile unsigned char ITRFRE1 @0x08;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT EXT_INT1
volatile unsigned char ITRFRE1; 
#endif

/* MISCELLANEOUS REGISTER */

#ifdef COSMIC
volatile unsigned char MISCR @0x09;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT MISCR
volatile unsigned char MISCR;
#endif

/* ADC REGISTERS */

#ifdef COSMIC
volatile unsigned char ADCDRMSB @0x0A;
volatile unsigned char ADCDRLSB @0x0B;
volatile unsigned char ADCCSR @0x0C;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT ADC
volatile unsigned char ADCDRMSB;
volatile unsigned char ADCDRLSB;
volatile unsigned char ADCCSR;
#endif

/* WATCHDOG REGISTER */

#ifdef COSMIC
volatile unsigned char WDGCR @0x0D;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT WATCHDOG
volatile unsigned char WDGCR;
#endif

/* SPI REGISTERS */

#ifdef COSMIC
volatile unsigned char SPIDR @0x11;
volatile unsigned char SPICR @0x12;
volatile unsigned char SPISR @0x13;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT SPI
volatile unsigned char SPIDR;
volatile unsigned char SPICR;
volatile unsigned char SPISR;
#endif

/* PWM-ART REGISTERS */

#ifdef COSMIC
volatile unsigned char PWMDCR1 @0x14;
volatile unsigned char PWMDCR0 @0x15;
volatile unsigned char PWMCR @0x16;
volatile unsigned char ARTCSR @0x17;
volatile unsigned char ARTCAR @0x18;
volatile unsigned char ARTARR @0x19;
volatile unsigned char ARTICCSR @0x1A;
volatile unsigned char ARTICR1 @0x1B;
volatile unsigned char ARTICR2 @0x1C;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PWM_ART
volatile unsigned char PWMDCR1;
volatile unsigned char PWMDCR0;
volatile unsigned char PWMCR;
volatile unsigned char ARTCSR;
volatile unsigned char ARTCAR;
volatile unsigned char ARTARR;
volatile unsigned char ARTICCSR;
volatile unsigned char ARTICR1;
volatile unsigned char ARTICR2;
#endif

/* SCI REGISTERS */

#ifdef COSMIC
volatile unsigned char SCIERPR @0x1D;
volatile unsigned char SCIETPR @0x1E;
volatile unsigned char SCI_RESERVED @0x1F;
volatile unsigned char SCISR @0x20;
volatile unsigned char SCIDR @0x21;
volatile unsigned char SCIBRR @0x22;
volatile unsigned char SCICR1 @0x23;
volatile unsigned char SCICR2 @0x24;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT SCI
volatile unsigned char SCIERPR;
volatile unsigned char SCIETPR;
volatile unsigned char SCI_RESERVED;
volatile unsigned char SCISR;
volatile unsigned char SCIDR;
volatile unsigned char SCIBRR;
volatile unsigned char SCICR1;
volatile unsigned char SCICR2;
#endif

/* USB REGISTERS */

#ifdef COSMIC
volatile unsigned char USBPIDR @0x25;
volatile unsigned char USBDMAR @0x26;
volatile unsigned char USBIDR @0x27;
volatile unsigned char USBISTR @0x28;
volatile unsigned char USBIMR @0x29;
volatile unsigned char USBCTLR @0x2A;
volatile unsigned char USBDADDR @0x2B;
volatile unsigned char USBEP0RA @0x2C;
volatile unsigned char USBEP0RB @0x2D;
volatile unsigned char USBEP1RA @0x2E;
volatile unsigned char USBEP1RB @0x2F;
volatile unsigned char USBEP2RA @0x30;
volatile unsigned char USBEP2RB @0x31;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT USB
volatile unsigned char USBPIDR;
volatile unsigned char USBDMAR;
volatile unsigned char USBIDR;
volatile unsigned char USBISTR;
volatile unsigned char USBIMR;
volatile unsigned char USBCTLR;
volatile unsigned char USBDADDR;
volatile unsigned char USBEP0RA;
volatile unsigned char USBEP0RB;
volatile unsigned char USBEP1RA;
volatile unsigned char USBEP1RB;
volatile unsigned char USBEP2RA;
volatile unsigned char USBEP2RB;
#endif

/* TBU REGISTERS */

#ifdef COSMIC
volatile unsigned char TBUCV @0x36;
volatile unsigned char TBUCSR @0x37;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT TBU
volatile unsigned char TBUCV;
volatile unsigned char TBUCSR;
#endif

/* FLASH REGISTER */

#ifdef COSMIC
volatile unsigned char FCSR @0x38;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT FLASH
volatile unsigned char FCSR;
#endif

/* INTERRUPT 2 REGISTER */

#ifdef COSMIC
volatile unsigned char ITRFRE2 @0x39;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT EXT_INT2
volatile unsigned char ITRFRE2; 
#endif

/* USB ENDPOINT BUFFERS */

#ifdef COSMIC
unsigned char EP0OutBuffer[8] @0x180;
unsigned char EP0InBuffer[8] @0x188;
unsigned char EP1OutBuffer[8] @0x190;
unsigned char EP1InBuffer[8] @0x198;
unsigned char EP2OutBuffer[8] @0x1A0;
unsigned char EP2InBuffer[8] @0x1A8;
#endif

#ifdef HIWARE
#pragma DATA_SEG DMA_CTRL
unsigned char EP0OutBuffer[8];
unsigned char EP0InBuffer[8];
#pragma DATA_SEG DMA_OUT1
unsigned char EP1OutBuffer[8];
#pragma DATA_SEG DMA_IN1
unsigned char EP1InBuffer[8];
#pragma DATA_SEG DMA_OUT2
unsigned char EP2OutBuffer[8];
#pragma DATA_SEG DMA_IN2
unsigned char EP2InBuffer[8];
#endif

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

/*** END OF FILE ***/