/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED LIBRARY
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 4.21
#
# DESCRIPTION : Contain Remote Wake-Up functions.
#               
******************************************************************************/   

#include "USB_Rwu.h"
#include "USB_Opts.h"
#include "Macro.h"
#include "Lib_Bits.h"
#include "USB_Def.h"
#include "USB_Var.h"
#include "USB_Rc.h"
#include "USB.h"

#ifdef HIWARE
#include MAP_FILE
#pragma CODE_SEG USBLIB_ROM_USER
#endif

/*-----------------------------------------------------------------------------
ROUTINE NAME : 	Do_USB_RemoteWU
INPUT/OUTPUT : 	None
DESCRIPTION  : 	Send a Remote Wake-up signaling to the Host
				Reset USB_SUSPEND flag
-----------------------------------------------------------------------------*/
void Do_USB_RemoteWU(void)
{
	Byte i;
	Word j;
	
	DisableInterrupts;					// To respect the Rem WU duration
	USBCTLR &= ~CtrlSusp;				// Exit Logic Suspend & power up transceivers
	USBCTLR |= CtrlResu;				// Start Remote WU Signaling

	for (i=10; i>0; i--)				// Maintain K state for 10ms @Fcpu=8MHz
	{
		j=340;   // !! REM: if Fcpu different from 8MHz -> MODIFY THIS VALUE !!
		for(j; j>0; j--)
		{
          #asm
			NOP;
          #endasm
		}
	}

	USBCTLR &= ~CtrlResu;				// Stop Remote WU Signaling
	USBLibStatus &= ~USB_SUSPEND;		// Inform app code that suspend is over.
	EnableInterrupts;
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Start_USB_RemoteWU
INPUT/OUTPUT : None
DESCRIPTION  : Start a Remote Wake-up signaling to the Host 
			-> Application code must call the Stop_USB_RemoteWU() function after a 10ms delay !!
-----------------------------------------------------------------------------*/
void Start_USB_RemoteWU(void)
{
	USBCTLR &= ~CtrlSusp;				// Exit Logic Suspend & power up transceivers
	USBCTLR |= CtrlResu;				// Start Remote WU Signaling
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Stop_USB_RemoteWU
INPUT/OUTPUT : None
DESCRIPTION  : End Remote Wake-up signaling , initiated by Start_USB_RemoteWU().
				-> Reset USB_SUSPEND flag
-----------------------------------------------------------------------------*/
void Stop_USB_RemoteWU(void)
{
	USBCTLR &= ~CtrlResu;				// Stop Remote WU Signaling
	USBLibStatus &= ~USB_SUSPEND;		// Inform app code that suspend is over.
}	

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

/*** END OF FILE ***/