/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED LIBRARY
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 4.21
#
# DESCRIPTION : USB lib variables file
#
# HISTORY : 10/19/00 	-> Creation date
#
******************************************************************************/   

#ifndef USB_VAR_H
#define USB_VAR_H

#include "USB_Opts.h"
#include "Lib_Bits.h"

/*************** Aliases used by the library *****************************/

#define ResetDataToggleEP1_IN		USBEP1RA &= 0xBF
#define ResetDataToggleEP1_OUT		USBEP1RB &= 0xBF
#define ResetDataToggleEP2_IN		USBEP2RA &= 0xBF
#define ResetDataToggleEP2_OUT		USBEP2RB &= 0xBF


/********************************************/
/*				 Mask bits                  */
/********************************************/

#define MASK_EP					0x30		// Read the endpoint number
#define MASK_CNT				0x0F		// Read received byte number
                    
/* USBTransferStatus selector */                                                              
#define NO_DATA_STAGE		   	0x01		// A Status In will follow the Setup Token
#define DATA_STAGE_IN		   	0x02		// Transfer with IN data phase
#define DATA_STAGE_OUT		   	0x04		// Transfer with OUT data phase
#define ONE_MORE			    0x08		// Last DATA IN Transfer before STATUS OUT.
#define ADDRESS2SET			   	0x10		// Device address
#define SET_TX0_VALID		   	0x20		// Request to set EP0 Tx buffer to VALID.
#define SET_RX0_VALID		   	0x40		// Request to set EP0 Rx buffer to VALID.

/* USBPIDR selector */
#define TP                    	0xC0		// Read Token PID
#define TP_OUT                	0x00		// OUT Transaction
#define TP_IN                 	0x80		// IN Transaction
#define TP_SETUP              	0xC0		// Control transfer
#define JK_BUS_STATE		    0x06		// Select the 2 JK bus state monitor bits.
#define SE0_BUS_STATE		   	0x04		// Select SE0 bit.
#define J_STATE				   	0x00		
#define K_STATE				   	0x02		
#define SE0					    0x04		


// Endpoint Register (EPnR)
#define ST_OUT                	0x80		// Status OUT of Endpoint register
#define STAT                  	0x30		// Status bit of Endpoint register
#define DISABLE				   	0x00		// DISABLE mask
#define STALL                 	0x10		// STALL mask
#define NAK                   	0x20		// NAK mask
#define VALID                 	0x30		// VALID mask

// UsbCtrFlag selector
#define Int_Ctr_IN            	0x01		// Correct transfer IN
#define Int_Ctr_OUT           	0x02		// Correct transfer OUT
#define Int_Ctr_SETUP		   	0x04		// Correct transfer SETUP

// Control Register (CTLR)
#define CtrlSusp              	0x02		// Suspend Mode
#define CtrlResu              	0x08		// Resume
 
// Interrupt Status Register (ISTR)
#define Int_Sof				   	0x01
#define Int_Reset			    0x02
#define Int_Esusp			    0x04
#define Int_Ctr				   	0x20
#define Int_Susp			    0x80

// USB USBbmRequestType Recipient
#define RECIPIENT           	0x03		// Used to mask the recipient part D2..D0 in USBbmRequestType
#define REDEVICE            	0x00                                                                                              
#define REINTERFACE         	0x01
#define REENDPOINT          	0x02

// USB standard USBbRequest value
#define GET_STATUS				0
#define CLEAR_FEATURE_STALL     1
#define SET_FEATURE_STALL       3
#define SET_ADDRESS         	5
#define GET_DESCRIPTOR      	6
#define SET_DESCRIPTOR      	7
#define GET_CONFIGURATION   	8
#define SET_CONFIGURATION   	9
#define GET_INTERFACE       	10
#define SET_INTERFACE       	11

// USB Standard Descriptor Types
#define DEVICE_DESC              1
#define CONFIGURATION_DESC       2
#define STRING_DESC              3

// UsbInfo selector
#define DEFAULT_STATE			0x00
#define ADDRESS_STATE			0x01
#define CONFIGURED_STATE		0x02
#define USB_STATE				0x03

// USB Status Selector (DeviceStatusinfo)
#define SELF_POW				0x01
#define REMOTE_WAKE_UP_ENABLE	0x02
#define ENDPOINT0_STALLED		0x04
#define ENDPOINT1_STALLED		0x10
#define ENDPOINT2_STALLED		0x20

// USB HID Class USBbRequest selector
#define GET_REPORT          	1
#define GET_IDLE            	2
#define GET_PROTOCOL        	3
#define SET_REPORT          	9
#define SET_IDLE            	10
#define SET_PROTOCOL        	11

// USB HID class USBwValue[1] request selector
#define GET_INPUT				1
#define GET_OUTPUT				2
#define GET_FEATURE				3
#define SET_OUTPUT				2
#define SET_FEATURE		       	3

// USB HID Class Descriptor Types
#define HID_DESC            	0x21
#define REPORT_DESC         	0x22

// Values assigned to DataXferStatus variable
#define FIRST_DATA 		0
#define STILL_DATA		1
#define LAST_DATA		2

/************************************************/
/*	Library only variable prototypes         	*/
/************************************************/

#ifdef HIWARE
#pragma DATA_SEG SHORT MY_RAM0
#endif

extern Byte OUT_DataNumberEP0;
extern Byte OUT_DataNumberEP1;
extern Byte OUT_DataNumberEP2;
 
extern Byte DeviceStatusInfo;
extern Byte UsbReport[2];			// Used to report status to host.
extern Byte UsbInfo;
extern Byte UsbCtrFlag;

extern Byte *DataToSend;
extern Byte LengthToSend;

extern Byte *DescAddBasePointer;

extern Byte ConfigValue;
      
#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

#endif // USB_VAR_H

/*** END OF FILE ***/