/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : USB Descriptors file. Up to three descriptor sets can be compiled.
#
# HISTORY :
#								                                                              
******************************************************************************/ 

#include "Descript.h"
#include "User_Def.h"
#include "USB_Opts.h"
#include "USB_Def.h"
#include "Macro.h"
#include "Unicode.h"

#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#include "DFUDescript.h"
#endif

/* WARNING: !!! WHEN MODIFYING THIS FILE -->> YOU MUST UPDATE THE Descript.H FILE !!!*/ 

/*******************		Call table to user segments (seg 1 & 2)		***********************/

#ifdef USE_DEVICE_FIRMWARE_UPGRADE

#ifdef HIWARE
#pragma CONST_SEG STDDESC_TABLE
#endif

#ifdef COSMIC
#pragma section const {STDDESC_TABLE}
#endif

#endif

const Lib_Tab Descriptors = {
	Manufacturer_String,
	Language_String,
#ifdef USE_ADD_STRINGS
	Additional_String,
#endif
	P1_Name_String,
	P1_Device_Desc,
	P1_Config_Desc,
#ifdef USE_SERIAL_NUMBER
	P1_Serial_String,
#endif
#ifdef HID_APPLICATION	
	P1_Report_Desc,
#ifdef USE_P1_INTERFACE1
	P1_I1_Report_Desc,
#endif
#endif
#ifdef USE_PRODUCT2	
	P2_Name_String,
	P2_Device_Desc,
	P2_Config_Desc,
#ifdef USE_SERIAL_NUMBER
	P2_Serial_String,
#endif
#ifdef HID_APPLICATION	
	P2_Report_Desc,
#ifdef USE_P2_INTERFACE1
	P2_I1_Report_Desc,
#endif
#endif
#endif
};

#ifdef HIWARE
#pragma CONST_SEG STD_DESC
#endif

#ifdef COSMIC
#pragma section const {STD_DESC}
#endif

/********************************************************************************/
/*				DESCRIPTORS COMMON TO ALL PRODUCTS							  	*/	
/********************************************************************************/

const Byte Manufacturer_String[MANUFSTR_LEN] =	// COMMON TO ALL PRODUCTS
{
	MANUFSTR_LEN,	// Length of manuf String Descriptor 
	0x03,				// DescriptorType
	uS,					// Manufacturer
	uT,
	uM,
	ui,
	uc,
	ur,
	uo,
	ue,
	ul,
	ue,
	uc,
	ut,
	ur,
	uo,
	un,
	ui,
	uc,
	us
};

const Byte Language_String[4] =	// COMMON TO ALL PRODUCTS
{
	0x04,				// Length of String Descriptor
	0x03,				// DescriptorType
	0x09,  
	0x04				// US English
};

#ifdef USE_ADD_STRINGS
// Additional Strings (OPTIONAL) 
const Byte Additional_String[ADDISTR_LEN] = 
{
	ADDISTR_LEN, // Descriptor Length
	0x03,		// DescriptorType
	uA,
	uB,
	uC
};      
#endif

/********************************************************************************/
/*				DESCRIPTORS FOR THE PRODUCT1								  	*/	
/********************************************************************************/

const Byte P1_Name_String[P1_NAMESTR_LEN] = 
{
	P1_NAMESTR_LEN,	// Length of Product String Descriptor
	0x03,			// DescriptorType
	uE,
	uv,
	ua,
	ul,
	uK,
	ui,
	ut,
#ifdef DFU_NEW_FIRMWARE
	u2,
#else
	u1,
#endif
	uSPACE,                 
	uS,
	uT,
	u7,
	u2,
	u6,
#ifdef ST7262	
	u2,
#endif
#ifdef ST7263	
	u3,
#endif
#ifdef ST7263B	
	u3,
	uB,
#endif
	uSPACE,
	uMINUS,
	uSPACE,
	uL,
	ui,
	ub,
	u4,          // Library version = 4.10
	uPOINT,
	u1,
    u0,
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
	uSPACE,
	uPLUS,
	uSPACE,
	uD,
	uF,
	uU
#endif
};

#ifdef USE_SERIAL_NUMBER
const Byte P1_Serial_String[P1_SERIALSTR_LEN] = 
{
	P1_SERIALSTR_LEN,	// Length of Serial# String Descriptor
	0x03,				// DescriptorType
	uS,
	uT,
	u1
};
#endif
               
const Byte P1_Device_Desc[P1_DEVDESC_LEN] = 
{                 
	P1_DEVDESC_LEN, // bLength
	0x01,     	// bDescriptorType
	0x10,     	// bcdUSB : USB specification version 1.10
	0x01,     
	0x00,     	// bDeviceClass
	0x00,     	// bDeviceSubClass
	0x00,     	// bDeviceProtocol
	0x08,     	// bMaxPacketSize0
	0x83,     	// idVendor : STM vendor number = 0483h
	0x04,
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
	0x03,		// idProduct : Composite Device (Low Speed Evaluation Kit & DFU = FF03h)
	0xFF,
#else
	0x03,		// idProduct : Single Device (Low Speed Evaluation Kit = 0003h)
	0x00,
#endif
#ifdef DFU_NEW_FIRMWARE
	0x11,     	// bcdDevice : Project version 2.11 (example for DFU)
	0x02,
#else
	0x10,     	// bcdDevice : Project version 2.10
	0x02,
#endif
	INDEX_MANUFACTURER,	// Index of string Descriptor describing manufacturer
	INDEX_NAME,		// Index of string Descriptor describing product
	0x00,		// INDEX_SERIALNUM,	// Index of string Descriptor describing the device's serial number
	0x01		// bNumConfigurations : Only one configuration
};
   
const Byte P1_Config_Desc[P1_CONFDESC_LEN] = 
{
	// Configuration descriptor                                                                      
	0x09,		// bLength: Size of this descriptor in bytes
	0x02,		// bDescriptorType: Configuration descriptor type
	LOBYTE(P1_CONFDESC_LEN),	// Length of configuration descriptor.
	HIBYTE(P1_CONFDESC_LEN),	// Length of configuration descriptor.
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
	0x02,		// bNumInterfaces: 2 interfaces (HID and DFU)
#else
	0x01,		// bNumInterfaces: 1 interface (HID only)
#endif
	0x01,		// bConfigurationValue: Used by SetConfiguration request
	0x00,		// iConfiguration: Index of string descriptor describing the configuration (None)
	0xA0,		// bmAttributes: Bus Powered and Remote Wakeup
	0x0A,		// MaxPower 20 mA
	// Interface descriptor (Interface 0 = Evaluation Kit)
	0x09,		// bLength: Interface Descriptor size
	0x04,		// bDescriptorType: Interface descriptor type
	0x00,		// bInterfaceNumber: Interface Number = 0
	0x00,		// bAlternateSetting: No Alternate setting
	0x02,		// bNumEndpoints: two endpoints used
	0x03,		// bInterfaceClass: HID
	0x00,		// bInterfaceSubClass: No subclass
	0x00,		// bInterfaceProtocol: none
	0x00,		// iInterface: Index of string descriptor (No string value)
	// HID descriptor
	0x09,		// bLength: HID Descriptor size
	0x21,		// bDescriptorType: HID
	0x10,		// bcdHID(LSB): HID Class Spec release number (1.10)
	0x01,		// bcdHID(MSB)
	0x21,		// bCountryCode: Hardware target country US
	0x01,		// bNumDescriptors: Number of HID class descriptors to follow 
	0x22,		// bDescriptorType: Report
	LOBYTE(P1_REPTDESC_LEN),	// Length of report descriptor interface 0 (2 bytes)
	HIBYTE(P1_REPTDESC_LEN),	// Length of report descriptor interface 0 (2 bytes)		
	// Endpoint 1 descriptor
	0x07,		// bLength: Endpoint Descriptor size
	0x05,		// bDescriptorType: Endpoint descriptor type
	0x81,		// bEndpointAddress: Endpoint  1 IN
	0x03,		// bmAttributes: Interrupt endpoint
	0x08,		// wMaxPacketSize(LSB): 8 Bytes max (0x0008)
	0x00,		// wMaxPacketSize (MSB)
	0x14,       	// bInterval: Polling Interval (20 ms = 0x14)
	// Endpoint 2 descriptor
	0x07,		// bLength: Endpoint Descriptor size
	0x05,		// bDescriptorType: Endpoint descriptor type
	0x02,		// bEndpointAddress: Endpoint  2 OUT
	0x03,		// bmAttributes: Interrupt endpoint
	0x02,		// wMaxPacketSize(LSB): 2 Byte max (0x0002)
	0x00,		// wMaxPacketSize (MSB)
	0x14,     	// bInterval: Polling Interval (20 ms = 0x14)		
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
	// Interface descriptor (Interface 1 = DFU)
	DFU_RNTM_INTERFACE_DESC,
	// DFU Functional descriptor
	DFU_FUNCTIONAL_DESC
#endif
};

#ifdef HID_APPLICATION

// Report Descriptors exist only for HID devices
const Byte P1_Report_Desc[P1_REPTDESC_LEN] =	// Report desc Interface 0
{
	0x05, 0x8c,                                  // USAGE_PAGE (ST Page)
	0x09, 0x01,                                  // USAGE (Demo Kit)
	
	0xa1, 0x01,                                  // COLLECTION (Application)
	
	0x85, 0x01,                                  //     REPORT_ID (1)
	0x09, 0x03,                                  //     USAGE (LED Red)
	0x15, 0x00,                                  //     LOGICAL_MINIMUM (0)
	0x25, 0x01,                                  //     LOGICAL_MAXIMUM (1)
	0x75, 0x08,                                  //     REPORT_SIZE (8)
	0x95, 0x01,                                  //     REPORT_COUNT (1)
	0x91, 0x82,                                  //     OUTPUT (Data,Var,Abs,Vol)
	                
	0x85, 0x01,                                  //     REPORT_ID (1)
	0x09, 0x03,                                  //     USAGE (LED Red)
	0xB1, 0x82,                                  //     FEATURE (Data,Var,Abs,Vol)      
		                
	0x85, 0x02,                                  //     REPORT_ID (2)
	0x09, 0x02,                                  //     USAGE (Push Button)
	0x15, 0x00,                                  //     LOGICAL_MINIMUM (0)
	0x25, 0x01,                                  //     LOGICAL_MAXIMUM (1)
	0x75, 0x01,                                  //     REPORT_SIZE (1)
	0x81, 0x82,                                  //     INPUT (Data,Var,Abs,Vol)
	0x75, 0x07,                                  //     REPORT_SIZE (7)
	0x81, 0x83,                                  //     INPUT (Cnst,Var,Abs,Vol)
	
	0x85, 0x02,                                  //     REPORT_ID (2)
	0x09, 0x02,                                  //     USAGE (Push Button)
	0x75, 0x01,                                  //     REPORT_SIZE (1)
	0xB1, 0x82,                                  //     FEATURE (Data,Var,Abs,Vol)
	0x75, 0x07,                                  //     REPORT_SIZE (7)
	0xB1, 0x83,                                  //     FEATURE (Cnst,Var,Abs,Vol)
	
	0x85, 0x03,                                  //     REPORT_ID (3)
	0x09, 0x04,                                  //     USAGE (ADC in)
	0x15, 0x00,                                  //     LOGICAL_MINIMUM (0)
	0x26, 0xFF, 0x00,   	     	   	         //     LOGICAL_MAXIMUM (255)
	0x75, 0x08,                                  //     REPORT_SIZE (8)
	0x81, 0x82,                                  //     INPUT (Data,Var,Abs,Vol)
	
	0x85, 0x03,                                  //     REPORT_ID (3)
	0x09, 0x04,                                  //     USAGE (ADC in)
	0xB1, 0x82,                                  //     FEATURE (Data,Var,Abs,Vol)
	
	0x85, 0x04,                                  //     REPORT_ID (4)
	0x09, 0x05,                                  //     USAGE (PWM out)
	0x15, 0x00,                                  //     LOGICAL_MINIMUM (0)
	0x25, 0x64,	                                 //     LOGICAL_MAXIMUM (100)
	0x75, 0x08,                                  //     REPORT_SIZE (8)
	0x91, 0x82,                                  //     OUTPUT (Data,Var,Abs,Vol)
	
	0x85, 0x04,                                  //     REPORT_ID (4)
	0x09, 0x05,                                  //     USAGE (PWM out)
	0xB1, 0x82,                                  //     FEATURE (Data,Var,Abs,Vol)      
                
#ifdef USE_REPORT5                
	0x85, 0x05,                                  //     REPORT_ID (5)
	0x09, 0x06,                                  //     USAGE (Test)
	0x15, 0x00,                                  //     LOGICAL_MINIMUM (0)
	0x26, 0xFF, 0x00,                            //     LOGICAL_MAXIMUM (255)	
	0x95, REPORT5_LENGTH,	                     //     REPORT_COUNT               
	0x81, 0x82,                                  //     INPUT (Data,Var,Abs,Vol)	
	0x85, 0x05,                                  //     REPORT_ID (5)
	0x09, 0x06,                                  //     USAGE (Test)               
	0xB1, 0x82,                                  //     FEATURE (Data,Var,Abs,Vol)                                                                              
#endif
	
	0xC0                                         // END_COLLECTION
};

#ifdef USE_P1_INTERFACE1
const Byte P1_I1_Report_Desc[P1_I1_REPTDESC_LEN] =	// Report desc Interface 1
{
};
#endif	// End of Interface 1 section
#endif	// End of HID section
// End of PRODUCT1 section

#ifdef USE_PRODUCT2	
/******************************************************************************************/
/*				DESCRIPTORS FOR A RUN TIME SWITCHABLE SECOND PRODUCT	(PRODUCT2)		  */	
/******************************************************************************************/

const Byte P2_Name_String[P2_NAMESTR_LEN] =     // Product desc
{
    // Put your string here
};

#ifdef USE_SERIAL_NUMBER
const Byte P2_Serial_String[P2_SERIALSTR_LEN] = 
{
	// Put your string here
};
#endif
               
const Byte P2_Device_Desc[P2_DEVDESC_LEN] =	    // Device desc 
{                 
	// Put your descriptor here
};
   
const Byte P2_Config_Desc[P2_CONFDESC_LEN] =       // Configuration Descriptor
{
	// Put your descriptor here
};

#ifdef HID_APPLICATION	
// Report Descriptors exist only for HID devices
const Byte P2_Report_Desc[P2_REPTDESC_LEN] =	// Report desc Interface 0
{
	// Put your descriptor here
};

#ifdef USE_P2_INTERFACE1			
const Byte P2_I1_Report_Desc[P2_I1_REPTDESC_LEN] = // Report desc Interface 1
{
	// Put your descriptor here
};
#endif  // End of Interface 1 section 
#endif	// End of HID section
#endif	// End of PRODUCT2 section

#ifdef HIWARE
#pragma CONST_SEG DEFAULT
#endif

#ifdef COSMIC
#pragma section {}
#endif

/*** END OF FILE ***/
