/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : USB Descriptors header file
#
# HISTORY :
#								                                                              
******************************************************************************/

#ifndef DESCRIPT_H
#define DESCRIPT_H

#include "Lib_Bits.h"
#include "USB_Opts.h"
#include "User_Def.h"

/********************************************************************************/
/*				DESCRIPTORS COMMON TO ALL PRODUCTS							  	*/	
/********************************************************************************/
#define MANUFSTR_LEN        38		// Manufacturer string length (Byte)
#define ADDISTR_LEN		    8		// OPTIONAL: Additional string length (Byte) 
/**********************************************************************************/


/**********************************************************************************/
/*						DESCRIPTORS FOR THE PRODUCT1						  */	
/**********************************************************************************/

#if defined(ST7262) || defined(ST7263)
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#define P1_NAMESTR_LEN      64		// Product name string length (Byte)
#else
#define P1_NAMESTR_LEN      52		// Product name string length (Byte)
#endif
#endif

#ifdef ST7263B
#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#define P1_NAMESTR_LEN      66		// Product name string length (Byte)
#else
#define P1_NAMESTR_LEN      54		// Product name string length (Byte)
#endif
#endif

#define P1_SERIALSTR_LEN    8		// Serial number string length (Byte)

#define P1_DEVDESC_LEN      18      // Device descriptor length              

#ifdef USE_DEVICE_FIRMWARE_UPGRADE
#define P1_CONFDESC_LEN		57		// Total config desc length (Word)
#else
#define P1_CONFDESC_LEN		41		// Total config desc length (Word)
#endif

#ifdef USE_REPORT5
#define P1_REPTDESC_LEN		111		// Report desc interface 0 length (Word)
#else
#define P1_REPTDESC_LEN		 92		// Report desc interface 0 length (Word)
#endif

#define P1_I1_REPTDESC_LEN	NULL	        // OPTIONAL: Report desc interface 1 length (Word)
/**********************************************************************************/


#ifdef USE_PRODUCT2
/**********************************************************************************/
/*				DESCRIPTORS FOR A RUN TIME SWITCHABLE SECOND PRODUCT			  */	
/**********************************************************************************/
#if defined(ST7262) || defined(ST7263)
#define P2_NAMESTR_LEN      	42		// Product name string length (Byte)
#endif
#ifdef ST7263B
#define P2_NAMESTR_LEN      	44		// Product name string length (Byte)
#endif
#define P2_SERIALSTR_LEN     	8		// Serial number string length (Byte)
#define P2_DEVDESC_LEN      18      // Device descriptor length
#define P2_CONFDESC_LEN		59		// Total config desc lenght (Word)
#define P2_REPTDESC_LEN		81		// Report desc interface 0 length (Word)
#define P2_I1_REPTDESC_LEN	50		// OPTIONAL: Report desc interface 1 length (Word)
/**********************************************************************************/
#endif

/*******************		Call table to user segments (seg 1 & 2)		***********************/

typedef struct {
	Byte * Manuf;
	Byte * Lang;
#ifdef USE_ADD_STRINGS
	Byte * Add;
#endif
	Byte * P1_Name;
	Byte * P1_Device;	
	Byte * P1_Config;
#ifdef USE_SERIAL_NUMBER
	Byte * P1_Serial;
#endif
#ifdef HID_APPLICATION	
	Byte * P1_Report;
#ifdef USE_P1_INTERFACE1
	Byte * P1_I1_Report;
#endif
#endif
#ifdef USE_PRODUCT2	
	Byte * P2_Name;
	Byte * P2_Device;
	Byte * P2_Config;
#ifdef USE_SERIAL_NUMBER
	Byte * P2_Serial;
#endif
#ifdef HID_APPLICATION	
	Byte * P2_Report;
#ifdef USE_P2_INTERFACE1
	Byte * P2_I1_Report;
#endif
#endif
#endif
} Lib_Tab;

/*******************		Descriptor prototypes		***********************/

#ifdef HIWARE
#pragma CONST_SEG STD_DESC
#endif

extern const Lib_Tab Descriptors;

extern const Byte Manufacturer_String[];
extern const Byte Language_String[];
extern const Byte Additional_String[];

extern const Byte P1_Name_String[];
extern const Byte P1_Serial_String[];
extern const Byte P1_Device_Desc[];
extern const Byte P1_Config_Desc[];
extern const Byte P1_Report_Desc[];
extern const Byte P1_I1_Report_Desc[];

extern const Byte P2_Name_String[];
extern const Byte P2_Serial_String[];
extern const Byte P2_Device_Desc[];
extern const Byte P2_Config_Desc[];
extern const Byte P2_Report_Desc[];
extern const Byte P2_I1_Report_Desc[];

#ifdef HIWARE
#pragma CONST_SEG DEFAULT
#endif 

#endif // DESCRIPT_H

/*** END OF FILE ***/
