/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : User initializations.
#
# HISTORY :
#								                                                              
******************************************************************************/

#include "My_Init.h"
#include "USB_Opts.h"
#include "User_Def.h"
#include "Macro.h"
#include "USB_Def.h"
#include "User_Var.h"
#include "USB_Var.h"
#include "USB_Lib.h"  

#ifdef HIWARE
#include MAP_FILE
#pragma CODE_SEG USER_ROM
#endif

/*-----------------------------------------------------------------------------
ROUTINE NAME : MCU_Init
INPUT/OUTPUT : None
DESCRIPTION  : MCU initialization
WARNING      : This function is also called by the Library (INT_EndSusp).
-----------------------------------------------------------------------------*/ 
void MCU_Init(void)
{
  IOPORTS_Init();
  ADC_Init();
  PWM_Init();

#ifdef ST7263
	MISCR = 0x0C;	// define Fclock = 12 MHz
#endif

#ifdef ST7262
    ITRFRE1 = 0x08; // Enable IT4 (falling edge on PA3) for USB Remote Wake Up -> SW3 
#endif

#if defined(ST7263) || defined(ST7263B)
    ITRFRE = 0x01; // Enable IT1 (rising edge on PA4) for USB Remote Wake Up -> SW2   
#endif
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : IOPORTS_Init
INPUT/OUTPUT : None
DESCRIPTION  : IO Ports initialization
-----------------------------------------------------------------------------*/ 
void IOPORTS_Init(void)
{
	PADR = 0xC0;	// LED1 and LED2 OFF
	PADDR = 0xC0;	// ST7262: PA6 (LED1, -) and PA7 (LED2, ON/OFF) in output
	                // ST7263: PA6 (LED1, PWM) and PA7 (LED2, ON-OFF) in output

	PBDR = 0x40;	// LED3 OFF
	PBDDR = 0x40;	// ST7262: PB6 (LED3, PWM)
	                // ST7263: PB6 (LED3, -)

	// Optional board modification : Remove W1, connect PB2 to W1B1    
	PBDR |= 0x04;	// Output 5v
	PBDDR |= 0x04;	// Power ADC resistor
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : ADC_Init
INPUT/OUTPUT : None
DESCRIPTION  : ADC initialization
-----------------------------------------------------------------------------*/ 
void ADC_Init(void)
{
        ADCCSR = 0x20; // ADC converter is ON
                       // ST7262 : Conversion is on PA0 (AIN0)
                       // ST7263 and ST7263B : Conversion is on PB0 (AIN0)

	// Wait for 30us to stabilize ADC
	for(IN_CountPass=100;IN_CountPass>0;IN_CountPass--); // Global used to remove reentrancy pb
} 

/*-----------------------------------------------------------------------------
ROUTINE NAME : PWM_Init
INPUT/OUTPUT : None
DESCRIPTION  : PWM initialization
-----------------------------------------------------------------------------*/ 
void PWM_Init(void)
{
#ifdef ST7262
        /* PWM AUTO-RELOAD TIMER registers setting */
        PWMCR   = 0x10;  // PWM0 (PB6) is selected
        ARTCSR  = 0x78;  // CPU clock, 62.5kHz, counter enabled
        PWMDCR0 = 0x00;                 
#endif
#if defined(ST7263) || defined(ST7263B)
	/* TIMER 1 CONTROL REGISTERS...............................................*/
	/*        7       6       5       4       3       2       1       0        */
	/* CR1 - ICIE     OCIE    TOIE    FOLV1   FOLV2   OLVL2   IEDG1   OLVL1    */
	/* CR2 - TCM1E    TCM2E    OPM     PWM     CC1     CC0    IEDG2   EXEDG    */
	/*.........................................................................*/
    TIMSR &= ~0x04;		// Enable Timer after it has been disabled for Halt mode
	TIMCR1	= 0x04;		// A 1 will be copied to OC1pin when timer matches OCR2
	TIMCR2	= 0x90;		// Internal clock divided by 4 => CC1=0 CC0=0, PWM enabled
	TIMOC1HR = 0;
	TIMOC1LR = 100;
	TIMOC2HR = 0;
	TIMOC2LR = 100;		// 20 kHz frequency
#endif
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Init_App_HW
INPUT/OUTPUT : None
DESCRIPTION  : This function is called in the main.c file, prior to any other function.
				-->> It handles user initialization.
-----------------------------------------------------------------------------*/ 
void Init_App_HW(void)
{ 
	/********************************************/
	/*			USER  INITIALIZATION	        */
	/********************************************/
#ifdef USE_HID_IDLE
	Idle_Value = 0; // default = 0 (report data on input change only)
#endif
#ifdef USE_HID_PROTOCOL
	Protocol_Value = 1; // default = 1 (report protocol)
#endif

	Button_Pressed = FALSE;    // Initial push button state = released
	Applet_Data_Ready = FALSE; // No data to send

	MCU_Init();   	                                                                         
	
	/* MULTI PRODUCT SUPPORT */
	//if (PADR & 0x??) // Switch is released (default)
	USBLibStatus = PRODUCT1; // to enumerate PRODUCT1 
	//else // Switch is pressed
	//	USBLibStatus = PRODUCT2; // to enumerate PRODUCT2
	// Note: Perform "USBLibStatus = DFU_MODE;" to enumerate DFU_MODE

    USBDataXferStatus = FIRST_DATA;	// Reset variable to send/receive more than 8 data
	
	// Reset variables for IN reports
	IN_tempo = 0;
	IN_CountPass = 0;
	IN_StillToSend = 0;

#ifdef USE_DEVICE_FIRMWARE_UPGRADE
	USBLibStatus2 = 0; // Used to store DFU_DETACH request
#endif

}

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

/*** END OF FILE ***/
