/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : USB lib configuration file. 
#	        Configure your application USB features here (configure USB lib).
#
# HISTORY :
#							                                                              
******************************************************************************/
   
#ifndef USB_OPTS_H
#define USB_OPTS_H   
   
#define USE_SERIAL_NUMBER		// Enable USB serial number reporting  (see Descript.c)

#define USE_USB_REMOTE_WAKE_UP		// Ability for a peripheral to wake up the host

#define USE_DEVICE_FIRMWARE_UPGRADE	// Ability to download a new firmware through USB link on ST7 Flash (Sectors 1 & 2).
					
#define USE_USB_GET_INTERFACE
#define USE_USB_SET_INTERFACE

//#define USE_EP0_CLEAR_FEATURE     // Enable ClearFeature on EP0

//#define INIT_APP_ON_USB_RESET     // Enable Application Init when USB Reset is detected 
#define INIT_APP_ON_END_SUSP      // Enable Application Init when End Suspend is detected 

#define ENABLE_USER_STATUS_IN     // Enable Call-back function during Status IN stage
#define ENABLE_USER_STATUS_OUT    // Enable Call-back function during Status OUT stage

/********************************************************************************************/
/*			Following section concerns multiple interfaces & products support				*/
/*							------------------------------									*/
/*	Allow user to have the same ROM code for a maximum of 2 different products				*/
/*	which means a Run time selection between 2 sets of Descriptors.							*/
/*																							*/
/*	Depending on the selection below, either the PRODUCT1, or PRODUCT1 +					*/	
/*	PRODUCT2  descriptors will be compiled.													*/
/*																							*/
/*	NOTE: PRODUCT1 is  ALWAYS DEFINED														*/
/********************************************************************************************/

//#define USE_P1_INTERFACE1			// Define a second interface (interface 1) on PRODUCT1.
//#define USE_PRODUCT2				// Define a second product (PRODUCT2)
//#define USE_P2_INTERFACE1			// Define a second interface (interface 1) on PRODUCT2.


#define HID_APPLICATION			    // Human Interface Device
/********************************************************************************************/
/*					Following section concerns HID devices	only							*/
/********************************************************************************************/
//#define USE_HID_IDLE				// HID optional request (cf. HID spec).
//#define USE_HID_PROTOCOL			// HID optional request (cf. HID spec) -> Boot devices only.
#define USE_HID_SET_REPORT		// HID optional request (allow host to send a report through EP0)
/********************************************************************************************/



/********************************************************************************************/
/*				Following section concerns optional USB requests							*/
/********************************************************************************************/
//#define USE_VENDOR_REQUESTS	    // Enable Vendor Requests
//#define USE_ADD_STRINGS			// Enable reporting of additional strings
/********************************************************************************************/




/********************************************************************************************/
/*					Following section selects your USB pipes configuration					*/
/*							------------------------------									*/
/* WARNING:	When modifying the following '#define', the DMA buffers must be allocated		*/ 
/*			accordingly in the linker file (ST72xxxx.prm)									*/
/*																							*/
/*	NOTE:  USE_ENDPOINT0_IN is always defined												*/
/********************************************************************************************/

#define USE_ENDPOINT0_OUT	// Enable "Data Stage Out" on EP0 (Set_Report, Vendor_Request with Data_Out)
#define USE_ENDPOINT1_IN        // StarterKit to Applet (Control "Button State" and "Trimmer Value" fields on Applet) 
//#define USE_ENDPOINT1_OUT     // Not used
//#define USE_ENDPOINT2_IN      // Not used
#define USE_ENDPOINT2_OUT       // Applet to StarterKit (Control ON-OFF and PWM LEDs on StarterKit)

#endif // USB_OPTS_H

/*** END OF FILE ***/