/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Applications variables declaration.
#
# HISTORY :
#								                                                              
******************************************************************************/

#include "User_Var.h"
#include "USB_Opts.h"
#include "Macro.h"
#include "User_Def.h"
  
#ifdef HIWARE
#pragma DATA_SEG SHORT MY_RAM0
#endif

#ifdef USE_HID_IDLE
Byte Idle_Value;			//  to support USE_HID_IDLE request (OPTIONAL)
#endif
#ifdef USE_HID_PROTOCOL
Byte Protocol_Value;		//  to support USE_HID_PROTOCOL request (OPTIONAL)
#endif

Byte Applet_DataReceived[8]; // Data received from Host : OUT
Byte Applet_DataToSend[8];   // Data sent to Host : IN 
Bool Applet_Data_Ready;      // True when data are ready to be sent or ready to be read
Bool Button_Pressed;         // Flag used to determine if the button has been pressed

Word IN_tempo;               // Flag used to switch between the different IN reports
Byte IN_NbBytesToSend;       // Actual number of bytes to send for next IN transfer
Byte IN_CountPass;           // Count the number of pass for a IN transfer
Byte IN_StillToSend;         // Count the number of bytes still to send for a IN transfer

#ifdef USE_REPORT5
Byte Report5DataFromPC[REPORT5_LENGTH]; // Save Report #5 data coming from PC
#endif
  
#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

/*** END OF FILE ***/