/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.1
#
# LIB VERSION : 4.21
#
# DESCRIPTION : Applications variables declaration header file
#
# HISTORY :
#								                                                              
******************************************************************************/

#ifndef USER_VAR_H
#define USER_VAR_H

#include "Lib_Bits.h"
#include "User_Def.h"

#ifdef HIWARE
#pragma DATA_SEG SHORT MY_RAM0
#endif

#ifdef USE_HID_IDLE
extern Byte Idle_Value;			//  to support USE_HID_IDLE request (OPTIONAL)
#endif
#ifdef USE_HID_PROTOCOL
extern Byte Protocol_Value;		//  to support USE_HID_PROTOCOL request (OPTIONAL)
#endif

extern Byte Applet_DataReceived[8];
extern Byte Applet_DataToSend[8]; 
extern Bool Applet_Data_Ready;                 
extern Bool Button_Pressed;

extern Word IN_tempo;	
extern Byte IN_NbBytesToSend;
extern Byte IN_CountPass;
extern Byte IN_StillToSend;

#ifdef USE_REPORT5
extern Byte Report5DataFromPC[REPORT5_LENGTH];
#endif

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

#endif // USER_VAR_H

/*** END OF FILE ***/