/*** (c) STMicroelectronics ***************************************************
#
# PROJECT :
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : Information file.
#
******************************************************************************/

#include "Lib_Bits.h"
#include "Unicode.h"

#define PRODUCT_LENGTH 16
#define VERSION_LENGTH  7
#define FLASH_SIZE     16

typedef struct {
  Byte *Product;
  Byte ProductLength;
  Byte *Version;
  Byte VersionLength;
  Byte FlashSize;
} InfoStruct;

#ifdef COSMIC
#pragma section const {APPLI_CONST}
#endif

#ifdef HIWARE
#pragma CONST_SEG APPLI_CONST
#endif

const Byte ProductString[PRODUCT_LENGTH] = {'D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n'};
const Byte VersionString[VERSION_LENGTH] = {'V','1','.','0','.','1','2'}; 

#ifdef COSMIC
#pragma section const {JUMP_INFO}
#endif

#ifdef HIWARE
#pragma CONST_SEG JUMP_INFO
#endif

const InfoStruct Info = {
  ProductString,
  PRODUCT_LENGTH,
  VersionString,
  VERSION_LENGTH,
  FLASH_SIZE
};

#ifdef COSMIC
#pragma section const {}
#endif

#ifdef HIWARE
#pragma CONST_SEG DEFAULT
#endif

/*** END OF FILE ***/