/*** (c) STMicroelectronics ***************************************************
#
# PROJECT :
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : Interrupt functions for ST7262.
#								                                                              
******************************************************************************/

#include "Macro.h" 
#include "Lib_Bits.h"

#ifdef COSMIC
#pragma section (APPLI_CODE)
#endif

#ifdef HIWARE
#include MAP_FILE
#pragma CODE_SEG APPLI_CODE
#endif

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Adc
DESCRIPTION  : ADC End Of Convertion Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Adc(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Adc(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Sci
DESCRIPTION  : SCI Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Sci(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Sci(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Spi
DESCRIPTION  : SPI Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Spi(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Spi(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_ArtPwmTimer
DESCRIPTION  : ART/PWM Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_ArtPwmTimer(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_ArtPwmTimer(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Tbu
DESCRIPTION  : TBU Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Tbu(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Tbu(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_IT1IT4
DESCRIPTION  : PORTA Interrupt routine. Used for Remote Wake Up (SW3 on PA3 = IT4).
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_IT1IT4(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC SAVE_REGS
void INT_IT1IT4(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_IT5IT8
DESCRIPTION  : PORTB Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_IT5IT8(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_IT5IT8(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_IT9IT12
DESCRIPTION  : PORTC Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_IT9IT12(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_IT9IT12(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Flash
DESCRIPTION  : FLASH Interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Flash(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Flash(void)
#endif
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : INT_Trap
DESCRIPTION  : TRAP interrupt routine.
-----------------------------------------------------------------------------*/ 
#ifdef COSMIC
@interrupt void INT_Trap(void)
#endif
#ifdef HIWARE
#pragma TRAP_PROC //SAVE_REGS
void INT_Trap(void)
#endif
{
}

#ifdef COSMIC
#pragma section ()
#endif

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

/*** END OF FILE ***/