#***(c) STMicroelectronics ****************************************************
#
# PROJECT :
#
# COMPILER : COSMIC
#
# VERSION :
#
# DESCRIPTION : Make file for the ST7263B 16K
#
#******************************************************************************

#*** PRODUCT, SIZE AND PROGRAM MEMORY DEFINITION ***

# Here declare your product name, size and start of the Program Memory 
PRODUCT  = 7262
SIZE     = 16K
PROG_MEM = 0xC000
PROJECT  = DFUnoUSBapp

#*** PATHS DEFINITION ***

# Here you declare where you store the different tools
TOOLS_PATH = C:\Cosmic\St7

# Here you declare where you store your project sources
PRJ_PATH = D:\Vss\ST7USBLS-DFUnoUSBapp\Work\Sources

#*** SUB PATHS DEFINITION ***

APPLI_PATH  = $(PRJ_PATH)\Appli

USB_PATH    = $(PRJ_PATH)\USBDFU\USB
DFU_PATH    = $(PRJ_PATH)\USBDFU\DFU
FLH_PATH    = $(PRJ_PATH)\USBDFU\HDFlashDriver

MACRO_PATH  = $(PRJ_PATH)\Macro
MICRO_PATH  = $(PRJ_PATH)\Micro
CONFIG_PATH = $(PRJ_PATH)\Config\Cosmic
OBJ_PATH    = $(PRJ_PATH)\Objects\Cosmic

#*** I/O FILES DEFINITION ***

LKF_FILE = $(CONFIG_PATH)\ST$(PRODUCT)_$(SIZE).lkf
MAK_FILE = $(CONFIG_PATH)\ST$(PRODUCT)_$(SIZE).mak

ST7_FILE = $(OBJ_PATH)\$(PROJECT).st7
ELF_FILE = $(OBJ_PATH)\$(PROJECT).elf
S19_FILE = $(OBJ_PATH)\$(PROJECT).s19
MAP_FILE = $(OBJ_PATH)\$(PROJECT).map
 
#*** COMMANDS DEFINITION ***

# Here you declare which tool will be used : C Compiler, Assembler, Linker, etc...
COMP = $(TOOLS_PATH)\cxst7.exe 
ASM  = $(TOOLS_PATH)\cast7.exe
LINK = $(TOOLS_PATH)\clnk.exe
CONV = $(TOOLS_PATH)\cvdwarf.exe
CHEX = $(TOOLS_PATH)\chex.exe

# Here you declare which options are to be used by the different tools
# To be used for uncrypted sources
CFLAGS  = +modm +debug -co $(OBJ_PATH) -i $(APPLI_PATH) -i $(USB_PATH) -i $(DFU_PATH) -i $(FLH_PATH) -i $(MACRO_PATH) -i $(MICRO_PATH) \
          -l -dCOSMIC -dST$(PRODUCT) -p -hMap_$(PRODUCT).c
AFLAGS  = -xx -l
LFLAGS  = -o $(ST7_FILE) -m $(MAP_FILE) -v -sa
HFLAGS  = -e $(PROG_MEM) -o $(S19_FILE)

# Commands set-up
CC  = $(COMP) $(CFLAGS)
CCY = $(COMP) $(CFLAGSY)
AS  = $(ASM) $(AFLAGS)
LK  = $(LINK) $(LFLAGS)
CV  = $(CONV)
HX  = $(CHEX) $(HFLAGS)

#*** OBJECT FILES DEFINITION ***

# Here you define all the application objects and their location
OBJ_LIST = $(OBJ_PATH)\Vect_$(PRODUCT).o $(OBJ_PATH)\Info.o $(OBJ_PATH)\Int_$(PRODUCT).o $(OBJ_PATH)\Main.o \
           $(OBJ_PATH)\USB.o $(OBJ_PATH)\USB_Lib.o $(OBJ_PATH)\USB_Rc.o $(OBJ_PATH)\USB_Var.o \
           $(OBJ_PATH)\DFUCore.o $(OBJ_PATH)\DFUDescript.o $(OBJ_PATH)\DFUProtocol.o
 
#*** S19 FILE CREATION ***

# Here, Conversion from COSMIC format (.ST7) to Hexadecimal format (.S19) for EPB
$(S19_FILE): $(ELF_FILE)
	$(HX) $(ST7_FILE)
             
#*** COSMIC TO STVD7 CONVERSION ***
             
# Here, Conversion from COSMIC format (.ST7) to STVD7 format (.ELF)
$(ELF_FILE): $(ST7_FILE)
	$(CV) $(ST7_FILE)
        
#*** LINKING ***  
        
# Here, all the object files are linked all together to create a .ST7 file 
$(ST7_FILE): $(OBJ_LIST)
	$(LK) $(LKF_FILE) 	      

#*** COMPILATION ***

#------------------
# CONFIG DIRECTORY
#------------------

$(OBJ_PATH)\Vect_$(PRODUCT).o: $(CONFIG_PATH)\Vect_$(PRODUCT).c
	$(CC) $(CONFIG_PATH)\Vect_$(PRODUCT).c
	
#-----------------
# APPLI DIRECTORY
#-----------------

$(OBJ_PATH)\Info.o: $(APPLI_PATH)\Info.c 
	$(CC) $(APPLI_PATH)\Info.c
	
$(OBJ_PATH)\Int_$(PRODUCT).o: $(APPLI_PATH)\Int_$(PRODUCT).c
	$(CC) $(APPLI_PATH)\Int_$(PRODUCT).c
					
$(OBJ_PATH)\Main.o: $(APPLI_PATH)\Main.c 
	$(CC) $(APPLI_PATH)\Main.c
	
#---------------
# USB DIRECTORY
#---------------

$(OBJ_PATH)\USB.o: $(USB_PATH)\USB.c
	$(CC) $(USB_PATH)\USB.c
	
$(OBJ_PATH)\USB_Lib.o: $(USB_PATH)\USB_Lib.c
	$(CC) $(USB_PATH)\USB_Lib.c
	
$(OBJ_PATH)\USB_Rc.o: $(USB_PATH)\USB_Rc.c
	$(CC) $(USB_PATH)\USB_Rc.c

$(OBJ_PATH)\USB_Var.o: $(USB_PATH)\USB_Var.c
	$(CC) $(USB_PATH)\USB_Var.c

#--------------
# DFU DIRECTORY
#--------------

$(OBJ_PATH)\DFUCore.o: $(DFU_PATH)\DFUCore.c 
	$(CC) $(DFU_PATH)\DFUCore.c

$(OBJ_PATH)\DFUDescript.o: $(DFU_PATH)\DFUDescript.c 
	$(CC) $(DFU_PATH)\DFUDescript.c

$(OBJ_PATH)\DFUProtocol.o: $(DFU_PATH)\DFUProtocol.c 
	$(CC) $(DFU_PATH)\DFUProtocol.c
      
#*** COMMANDS CALLED BEFORE 'REBUILD ALL' PROCESS ***
      
clean :                         
	del $(OBJ_PATH)\*.o
	del $(OBJ_PATH)\*.st7
	del $(OBJ_PATH)\*.elf
	del $(OBJ_PATH)\*.s19
	del $(OBJ_PATH)\*.ls
	del $(OBJ_PATH)\*.lst
	del $(OBJ_PATH)\*.map
	$(MAKE) -f $(MAK_FILE)
	
#*** END OF FILE ***