/*** (c) STMicroelectronics ***************************************************
#
# PROJECT :
#
# COMPILER : COSMIC
#
# VERSION :
#
# DESCRIPTION : ST7262 Interrupt vectors call table.
#
******************************************************************************/

// Define interrupt service routines as external functions

//extern void _stext(); // -> use with startup file crts*.s
extern void INT_Trap(); 
extern void INT_Flash();
extern void INT_EndSusp();
extern void INT_IT1IT4();
extern void INT_IT5IT8();
extern void INT_IT9IT12();
extern void INT_Tbu();
extern void INT_ArtPwmTimer();
extern void INT_Spi();
extern void INT_Sci();
extern void INT_Usb();
extern void INT_Adc();
extern void DFU_Main();

// Assign ISR to interrupt vectors

#pragma section const {vector}

void (* const _vectab[])() = 
{          
	INT_Adc,
	INT_Usb,
	INT_Sci,  
	INT_Spi,
	INT_ArtPwmTimer,
	INT_Tbu,
	INT_IT9IT12,
	INT_IT5IT8,
	INT_IT1IT4,
	INT_EndSusp,
	INT_Flash,
	INT_Trap,
	DFU_Main // FFFEh-FFFFh : reset vector
};                     

/*** END OF FILE ***/