/*** (c) STMicroelectronics ***************************************************
#
# COMPILER : COSMIC / HIWARE
#
# DESCRIPTION : Register mapping for ST7261
#
******************************************************************************/

#ifdef HIWARE
#include "Map_7261.h"
#endif

/* PORTA REGISTERS */

#ifdef COSMIC
volatile unsigned char PADR @0x00;
volatile unsigned char PADDR @0x01;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTA
volatile unsigned char PADR;
volatile unsigned char PADDR;
#endif

/* PORTB REGISTERS */

#ifdef COSMIC
volatile unsigned char PBDR @0x02;
volatile unsigned char PBDDR @0x03;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT PORTB
volatile unsigned char PBDR;
volatile unsigned char PBDDR;
#endif

/* INTERRUPT 1 REGISTER */

#ifdef COSMIC
volatile unsigned char ITRFRE1 @0x08;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT EXT_INT1
volatile unsigned char ITRFRE1; 
#endif

/* MISCELLANEOUS REGISTER */

#ifdef COSMIC
volatile unsigned char MISCR @0x09;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT MISCR
volatile unsigned char MISCR;
#endif

/* WATCHDOG REGISTER */

#ifdef COSMIC
volatile unsigned char WDGCR @0x0D;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT WATCHDOG
volatile unsigned char WDGCR;
#endif

/* USB REGISTERS */

#ifdef COSMIC
volatile unsigned char USBPIDR @0x25;
volatile unsigned char USBDMAR @0x26;
volatile unsigned char USBIDR @0x27;
volatile unsigned char USBISTR @0x28;
volatile unsigned char USBIMR @0x29;
volatile unsigned char USBCTLR @0x2A;
volatile unsigned char USBDADDR @0x2B;
volatile unsigned char USBEP0RA @0x2C;
volatile unsigned char USBEP0RB @0x2D;
volatile unsigned char USBEP1RA @0x2E;
volatile unsigned char USBEP1RB @0x2F;
volatile unsigned char USBEP2RA @0x30;
volatile unsigned char USBEP2RB @0x31;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT USB
volatile unsigned char USBPIDR;
volatile unsigned char USBDMAR;
volatile unsigned char USBIDR;
volatile unsigned char USBISTR;
volatile unsigned char USBIMR;
volatile unsigned char USBCTLR;
volatile unsigned char USBDADDR;
volatile unsigned char USBEP0RA;
volatile unsigned char USBEP0RB;
volatile unsigned char USBEP1RA;
volatile unsigned char USBEP1RB;
volatile unsigned char USBEP2RA;
volatile unsigned char USBEP2RB;
#endif

/* TBU REGISTERS */

#ifdef COSMIC
volatile unsigned char TBUCV @0x36;
volatile unsigned char TBUCSR @0x37;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT TBU
volatile unsigned char TBUCV;
volatile unsigned char TBUCSR;
#endif

/* FLASH REGISTER */

#ifdef COSMIC
volatile unsigned char FCSR @0x38;
#endif

#ifdef HIWARE
#pragma DATA_SEG SHORT FLASH
volatile unsigned char FCSR;
#endif

/* USB ENDPOINT BUFFERS */

#ifdef COSMIC
unsigned char EP0OutBuffer[8] @0x80;
unsigned char EP0InBuffer[8] @0x88;
unsigned char EP1OutBuffer[8] @0x90;
unsigned char EP1InBuffer[8] @0x98;
unsigned char EP2OutBuffer[8] @0xA0;
unsigned char EP2InBuffer[8] @0xA8;
#endif

#ifdef HIWARE
#pragma DATA_SEG DMA_CTRL
unsigned char EP0OutBuffer[8];
unsigned char EP0InBuffer[8];
#pragma DATA_SEG DMA_OUT1
unsigned char EP1OutBuffer[8];
#pragma DATA_SEG DMA_IN1
unsigned char EP1InBuffer[8];
#pragma DATA_SEG DMA_OUT2
unsigned char EP2OutBuffer[8];
#pragma DATA_SEG DMA_IN2
unsigned char EP2InBuffer[8];
#endif

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

/*** END OF FILE ***/