/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : Device Firmware Upgrade descriptor file	 	
#				
******************************************************************************/   

#include "DFUDescript.h"
#include "USB_Def.h"
#include "Lib_Bits.h" 
#include "Macro.h"
#include "Unicode.h"

/****************************************************************************************/
/*			DESCRIPTORS FOR DEVICE FIRMWARE UPGRADE MODE	 		*/	
/****************************************************************************************/

#ifdef HIWARE
#pragma CONST_SEG DFU_DESC
#endif

#ifdef COSMIC
#pragma section const {DFU_DESC}
#endif

// DFU Mode Device Descriptor	               
const Byte DFU_Device_Desc[DFU_DEVDESC_LEN] = 
{
	DFU_DEVDESC_LEN,  	// bLength : Size of this descriptor in bytes
	0x01,     		// bDescriptorType : Device descriptor type
	0x10,     		// bcdUSB : USB specification version 1.10
	0x01,     
	0xFE,     		// bDeviceClass : Application Specific Class Code
	0x01,     		// bDeviceSubClass : DFU Code
	0x00,     		// bDeviceProtocol : none
	0x08,     		// bMaxPacketSize0 : Maximum packet size for EndPoint0
	0x83,     		// idVendor : STM vendor number = 0483h
	0x04,
	0x11,			// idProduct : DFU = DF11h (reserved in STM)
	0xDF,
	0x00,     		// bcdDevice : 1.00
	0x01,
	INDEX_MANUFACTURER,	// Index of String descriptor describing manufacturer
	INDEX_NAME,	 	// Index of String descriptor describing product
	0x00,			// Index of String descriptor describing the device's serial number
	0x01			// bNumConfigurations : Only one configuration for DFU                 
};

// DFU Mode Configuration Descriptor   
const Byte DFU_Config_Desc[DFU_CONFDESC_LEN] =
{       
	// Configuration Descriptor
	0x09,		// bLength : Size of this descriptor in bytes
	0x02,		// bDescriptorType : Configuration descriptor type
	LOBYTE(DFU_CONFDESC_LEN),	// Total length of this Configuration descriptor
	HIBYTE(DFU_CONFDESC_LEN),	// Total length of this Configuration descriptor
	0x01,		// bNumInterfaces : 1 interface (DFU only)
	0x01,		// bConfigurationValue : Used by SetConfiguration request
	0x00,		// iConfiguration : Index of string descriptor describing the configuration (None)
	0x80,		// bmAttributes : Bus Powered and No Remote Wakeup
	0x32,		// MaxPower : 100 mA (50 x 2mA)
	// DFU Interface Descriptor
	DFU_INTERFACE_DESC,
	// DFU Functional Descriptor	
	DFU_FUNCTIONAL_DESC
};

/***********/
/* STRINGS */
/***********/

// DFU Mode Manufacturer String
const Byte DFU_Manuf_String[DFU_MANUFSTR_LEN] =
{
	DFU_MANUFSTR_LEN, // Length of String Descriptor 
	0x03,		  // DescriptorType
	uS,		  // Manufacturer = "STM"
	uT,
	uM
};

// DFU Mode Language String
const Byte DFU_Lang_String[DFU_LANGSTR_LEN] =
{
	DFU_LANGSTR_LEN, // Length of String Descriptor
	0x03,            // DescriptorType
	0x09,            // US English  
	0x04
};

// DFU Mode Product String
const Byte DFU_Name_String[DFU_NAMESTR_LEN] =
{
	DFU_NAMESTR_LEN, // Descriptor Length
	0x03,	 	 // DescriptorType
	uD,              // Product = "DFU"
	uF,
	uU
};

#ifdef HIWARE
#pragma CONST_SEG DEFAULT
#endif

#ifdef COSMIC
#pragma section const {}
#endif

/*** END OF FILE ***/