/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED EVALUATION KIT + DFU
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : Device Firmware Upgrade protocol header file
#
******************************************************************************/
   
#ifndef DFUPROTOCOL_H
#define DFUPROTOCOL_H

#include "Lib_Bits.h"

//-------------------------------------
// Constants used by variable DFUAction
//-------------------------------------
#define DFU_ACTION_NONE      0x00
#define DFU_ACTION_ERASE_S1  0x01
#define DFU_ACTION_ERASE_S2  0x02
#define DFU_ACTION_PROGRAM   0x04
#define DFU_ACTION_START     0x08

//-------------------------
// Reserved BlockNum Values
//------------------------- 
#define DFU_BLKNUM_ERASE_ALL 0xFFFF
#define DFU_BLKNUM_ERASE_S1  0xFFFE
#define DFU_BLKNUM_ERASE_S2  0xFFFD
                      
#ifdef ST7262
#define FCPU 8
#endif
#ifdef ST7263B
#define FCPU 4
#endif

//---------------------
// Variables Prototypes
//---------------------
extern Byte DFUAction;
extern Byte DFUVpp12V;
extern Byte *DFUpFlash;

//---------------------
// Functions Prototypes
//---------------------

#ifdef HIWARE
#pragma CODE_SEG DFU_PRTCL
#endif

extern Byte DFU_S1S2Valid(void);
extern void DFU_Init_User(void);
extern void DFU_Abort_User(void);
extern void DFU_ClearStatus_User(void);
extern void DFU_ManifestWaitReset_User(void);
extern void DFU_UpLoad_User(void);
extern void DFU_Download_User(void);

extern Byte VbusCheck(void);
extern void HDFlashProcess(void);
extern void SetVpp12V(void);
extern void SetVpp5V(void);

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

#endif // DFUPROTOCOL_H

/*** END OF FILE ***/