/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : HDFlash Driver
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 1.0
#
# DESCRIPTION : Drivers to program and erase HDFlash memory. 
#								                                                              
******************************************************************************/

#ifndef HDFLASH_H
#define HDFLASH_H

// Used to Enable or Disable functions 
#define USE_HDFLASH_ERASESECTOR
#define USE_HDFLASH_WRITEBYTE
#define USE_HDFLASH_WRITEBLOCK
#define USE_HDFLASH_PROGALL
#define USE_HDFLASH_WRITEOPTBYTE
#define USE_HDFLASH_READOPTBYTE
#define USE_HDFLASH_CHECKSUM

// Used to launch call-back function during Embedded command TimeOut
#define USE_TIMEOUT

// Embedded Command Parameters
#define EMBLG_PARAM_FREQ (*(unsigned char *)0xF8)
#define EMBLG_PARAM_DATA (*(unsigned char *)0xF9)
#define EMBLG_PARAM_ENDH (*(unsigned char *)0xFA)
#define EMBLG_PARAM_ENDL (*(unsigned char *)0xFB)
#define EMBLG_PARAM_PTRH (*(unsigned char *)0xFC)
#define EMBLG_PARAM_PTRL (*(unsigned char *)0xFD)
#define EMBLG_PARAM_SECT (*(unsigned char *)0xFE)
#define EMBLG_PARAM_ECMD (*(unsigned char *)0xFF)

// Embedded Command Return Status Codes
#define HDFLASH_BYTEPROG_OK   0x00
#define HDFLASH_BLOCKPROG_OK  0x01
#define HDFLASH_OPTIONPROG_OK 0x02
#define HDFLASH_ERASE_OK      0x03
#define HDFLASH_PROGALL_OK    0x04
#define HDFLASH_OPTIONREAD_OK 0x05
#define HDFLASH_CHECKSUM_OK   0x06

// Variables used by Application
#define HDFlashStatus EMBLG_PARAM_ECMD
#define CheckSumL     EMBLG_PARAM_ENDL
#define CheckSumH     EMBLG_PARAM_ENDH

// Miscellanous
#define HDFLASH_BUSY 0x80

#ifdef HIWARE
#pragma CODE_SEG HDFLASH_DRIVER
#endif

// Functions Prototypes

extern void RASS_Disable(unsigned char, unsigned char);

#ifdef USE_HDFLASH_ERASESECTOR
unsigned char extern HDFlashEraseSector(unsigned char, unsigned char);
#endif

#ifdef USE_HDFLASH_WRITEBYTE
unsigned char extern HDFlashWriteByte(unsigned char, unsigned int, unsigned char);
#endif

#ifdef USE_HDFLASH_WRITEBLOCK
unsigned char extern HDFlashWriteBlock(unsigned char *, unsigned char *, unsigned char, unsigned char);
#endif

#ifdef USE_HDFLASH_PROGALL
unsigned char extern HDFlashProgAll(unsigned char);
#endif

#ifdef USE_HDFLASH_WRITEOPTBYTE
unsigned char extern HDFlashWriteOptByte(unsigned char, unsigned char, unsigned char);
#endif

#ifdef USE_HDFLASH_READOPTBYTE
unsigned char extern HDFlashReadOptByte(unsigned char);
#endif

#ifdef USE_HDFLASH_CHECKSUM
unsigned char extern HDFlashChecksum(unsigned char *, unsigned char);
#endif

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

#endif

/*** END OF FILE ***/