/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED LIBRARY
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : USB lib interface file
#
******************************************************************************/   

/******************		Functions prototypes	***********************************/

#ifndef USB_LIB_H
#define USB_LIB_H

#include "Lib_Bits.h"

#ifdef HIWARE
#pragma CODE_SEG USBLIB_ROM     
#endif

extern void Init_USB_HW (void);
extern void Disable_USB_HW (void);
extern void Handle_USB_Events(void);
extern void Enable_STATUS_Stage(void);
extern void Set_EP_Ready(Byte Endpoint, Byte Direction, Byte Length);
extern void Write_EP_Buffer (Byte Endpoint, Byte *Data, Byte DataLength);
extern void Read_EP_Buffer (Byte Endpoint, Byte *DataDestination);

#ifdef HIWARE
#pragma CODE_SEG DEFAULT     
#endif

#endif // USB_LIB_H

/*** END OF FILE ***/