/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED LIBRARY
#
# COMPILER : COSMIC / HIWARE
#
# VERSION :
#
# DESCRIPTION : USB lib core file
#
******************************************************************************/   

#ifndef USB_RC_H
#define USB_RC_H

#include "Lib_Bits.h"

#ifdef HIWARE
#pragma CODE_SEG USBLIB_ROM
#endif

/********************************* Endpoint0 IN ***************************/
extern void SetEP0TxTbc(Byte);
extern void SetEP0TxStatus(Byte);
extern void SetEP0TxStatus_IT(Byte);
extern Byte GetEP0TxStatus(void);

/********************************* Endpoint0 OUT ***************************/
extern void SetEP0RxStatus(Byte);
extern void SetEP0RxStatus_IT(Byte);
extern Byte GetEP0RxStatus(void);

/********************************* MISCELLANEOUS ***************************/
extern void SetAddress(void);
extern void SetDmaAdd(Word);
extern void CheckValidResume(void);

/********************************* Endpoint1 IN ***************************/
extern void SetEP1TxTbc(Byte Tbc);
extern void SetEP1TxStatus(Byte);
extern Byte GetEP1TxStatus(void);

/********************************* Endpoint1 OUT ***************************/
extern void SetEP1RxStatus(Byte);
extern Byte GetEP1RxStatus(void);

/********************************* Endpoint2 IN ***************************/
extern void SetEP2TxTbc(Byte Tbc);
extern void SetEP2TxStatus(Byte);
extern Byte GetEP2TxStatus(void);

/********************************* Endpoint2 OUT ***************************/
extern void SetEP2RxStatus(Byte);
extern Byte GetEP2RxStatus(void);

#ifdef HIWARE
#pragma CODE_SEG DEFAULT
#endif

#endif // USB_RC_H

/*** END OF FILE ***/