/*** (c) STMicroelectronics ***************************************************
#
# PROJECT : ST7 USB LOW SPEED LIBRARY
#
# COMPILER : COSMIC / HIWARE
#
# VERSION : 4.21
#
# DESCRIPTION : USB lib variables file
#
# HISTORY : 10/19/00 	-> Creation date
#
******************************************************************************/   
                  
#include "USB_Var.h"                  
#include "USB_Opts.h"
#include "Macro.h"
#include "USB_Def.h"
#include "Lib_Bits.h"

/***************************************************************************/
/*****	VARIABLES SHARED BETWEEN LIB AND APPLI -> proto in USB_Def.h     ***/
/***************************************************************************/

/* USBTransferStatus specifies the current Control Transfer transaction stages :
  ------------------------------------------------------------------
  |     Phase name       | Value |            Description       
  ------------------------------------------------------------------
  |
  | NO_DATA_STAGE        | 0x01 | Control Transfer with IN data phase          
  |                             |                                  
  | DATA_STAGE_IN        | 0x02 | Control Transfer with IN data phase         
  |                             |                                     
  | DATA_STAGE_OUT	 | 0x04 | Control Transfer with OUT data phase   
  |                             |                                        
  | ONE_MORE		 | 0x08 | Following transaction will be either an Empty IN or a STATUS OUT.	
  |                             |   
  | ADDRESS2SET		 | 0x10 | Device address must be written after completion of Status Stage                  
  ------------------------------------------------------------------ */

#ifdef USE_DEVICE_FIRMWARE_UPGRADE
Byte USBLibStatus      @ 0x01B0; // Used to exchange USB status with application
Byte USBTransferStatus @ 0x01B1;
Byte USBDataXferStatus @ 0x01B2; // Used for sending/receiving more than 8 data
                                 // Values are : FIRST_DATA (init value), STILL_DATA and LAST_DATA
Byte USBbmRequestType  @ 0x01B3; 
Byte USBbRequest       @ 0x01B4;
Byte USBwValue[2]      @ 0x01B5;
Word USBwIndex         @ 0x01B7;
Word USBwLength        @ 0x01B9;
Byte USBLibStatus2     @ 0x01BB; // For more flags...
TParams GParams        @ 0x01BC; // Contains the parameters needed by the Library functions
                                 // called by the Application.
#else
#ifdef HIWARE
#pragma DATA_SEG SHORT MY_RAM0
#endif
Byte USBLibStatus;
Byte USBTransferStatus;
Byte USBDataXferStatus;
Byte USBbmRequestType;
Byte USBbRequest;
Byte USBwValue[2];
Word USBwIndex;
Word USBwLength;
#endif

/*************************************************************************/
/*****	 	LIBRARY ONLY VARIABLES  -> proto in USB_Var.h       ******/
/*************************************************************************/

#ifdef HIWARE
#pragma DATA_SEG SHORT MY_RAM0
#endif

#ifdef USE_ENDPOINT0_OUT
Byte OUT_DataNumberEP0;		// Used to save Number of received data on EP0 when Control OUT.
#endif

#ifdef USE_ENDPOINT1_OUT
Byte OUT_DataNumberEP1;		// Used to save Number of received data on EP1 when OUT Ctr.
#endif

#ifdef USE_ENDPOINT2_OUT
Byte OUT_DataNumberEP2;		// Used to save Number of received data on EP2 when OUT Ctr.
#endif

Byte DeviceStatusInfo;
/* This array specifies the status value of the specified 
        recipient (see USB spec.).
        
        For a device:
        DeviceStatusInfo
	  --------------------------------------------------------
	  | Bit7 | Bit6 | Bit5 | Bit4 | Bit3 | Bit2 | Bit1 | Bit0 |
	  --------------------------------------------------------
	  |  -   |  -   | EP2  | EP1  |EP0OUT|EP0IN |Remote| Self |
	  |      |      |      |      |      |      |Wakeup|Power.|  
	  -------------------------------------------------------- 
*/

Byte UsbReport[2];			// Used to report status to host.

Byte UsbInfo;				// Used to keep tracking of device state.

Byte UsbCtrFlag;
                  

Byte *DataToSend;
Byte LengthToSend;
                  
Byte *DescAddBasePointer;

Byte ConfigValue;		// Current Configuration

#ifdef HIWARE
#pragma DATA_SEG DEFAULT
#endif

/*** END OF FILE ***/