 /*******************************************************************
 *
 *    DESCRIPTION: Headerfile for DALI Interface SE
 *
 *    AUTHOR:
 *
 *    HISTORY:    
 *
 *******************************************************************/
#ifndef DALI_LOW_LEVEL_H
#define DALI_LOW_LEVEL_H

#define DALI_TIMER_LAG (unsigned int) (40 / TIMER_TICK)

#define DALI_SAMPLING_TIME 104.17

#define DALI_SAMPLING_TIME_RELOAD (unsigned int) (DALI_SAMPLING_TIME / TIMER_TICK)

#define DALI_SHORT_TIME	416.67				/* time for half Bi-phase in us */	
#define DALI_LONG_TIME  833.33				/* time for full Bi-phase in us */

#define DALI_BI_SHORT_RELOAD (unsigned int)(DALI_SHORT_TIME / TIMER_TICK)		/* half Bi-phase in timer ticks */

#define DALI_IDLE	  	    0		/* DALI sender: Idle mode */
#define DALI_SEND_START		1		/* DALI sender: send Start Condition */
#define DALI_SEND_ADDRESS	2		/* DALI sender: Send Address Bits*/
#define DALI_SEND_DATA	    3		/* DALI sender: Send Data Bits */
#define DALI_SEND_STOP		4		/* DALI sender: Send Stop Bits */
#define DALI_SEND_SETTLING  5       /* DALI sender: Wait Settling Time */
#define DALI_WAIT           6		/* Waiting for Answerframe */

#define DALI_SEND_NUMBER_START_BITS		1	/* DALI sender: number of start bits to send */
#define DALI_SEND_NUMBER_ADDRESS_BITS	8	/* DALI sender: number of address bits to send */
#define DALI_SEND_NUMBER_DATA_BITS		8   /* DALI sender: number of data bits to send */
#define DALI_SEND_NUMBER_STOP_BITS		2	/* DALI sender: number of stop bits to send */

#define DALI_RECEIVE_NUMBER_START_BITS		1	/* DALI sender: number of start bits to send */
#define DALI_RECEIVE_NUMBER_ADDRESS_BITS	0	/* DALI sender: number of address bits to send */
#define DALI_RECEIVE_NUMBER_DATA_BITS		8   /* DALI sender: number of data bits to send */
#define DALI_RECEIVE_NUMBER_STOP_BITS		2	/* DALI sender: number of stop bits to send */

#define DALI_RECEIVE_START		 0x11		/* DALI receiver: send Start Condition */
#define DALI_RECEIVE_ADDRESS	 0x12		/* DALI receiver: Send Address Bits*/
#define DALI_RECEIVE_DATA	     0x13		/* DALI receiver: Send Data Bits */
#define DALI_RECEIVE_STOP		 0x14		/* DALI receiver: Send Stop Bits */
#define DALI_RECEIVE_SETTLING	 0x15		/* DALI receiver: Wait settling time */
#define DALI_RECEIVE_ERROR       0xFF

#define DALI_TIMEOUT_RUN_RELOAD			        3        /* Te */
#define DALI_TIMEOUT_STOP_RELOAD		        (4+1)    /* Te */
#define DALI_TIMEOUT_RECEIVE_SETTLING_RELOAD    7		 /* Te */
#define DALI_TIMEOUT_SEND_SETTLING_LONG_RELOAD  22       /* Te */
#define DALI_TIMEOUT_SEND_SETTLING_SHORT_RELOAD	7		 /* Te */
#define DALI_TIMEOUT_RECEIVE_ANSWER_RELOAD      (unsigned int) (22*DALI_BI_SHORT_RELOAD)       /* Te */

#endif